/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.tags;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.dom4j.Element;
import org.dom4j.io.HTMLWriter;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.CMSException;

public class UserTag
extends SimpleTagSupport {
    private static final IPortalUrlFactory PORTAL_URL_FACTORY = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private static final IDirectoryServiceLocator DIRECTORY_SERVICE_LOCATOR = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");
    private String name;

    public void doTag() throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest request = pageContext.getRequest();
        NuxeoController nuxeoController = (NuxeoController)request.getAttribute("nuxeoController");
        if (nuxeoController != null) {
            String avatarSource;
            DirectoryPerson person = DIRECTORY_SERVICE_LOCATOR.getDirectoryService().getPerson(this.name);
            try {
                Link link = nuxeoController.getUserAvatar(this.name);
                avatarSource = link.getUrl();
            }
            catch (CMSException e) {
                avatarSource = "";
            }
            String displayName = person.getDisplayName();
            String profileURL = this.getUserProfilePageURL(nuxeoController, person);
            Element container = DOM4JUtils.generateElement((String)"span", null, null);
            Element avatar = DOM4JUtils.generateElement((String)"img", (String)"avatar", null);
            DOM4JUtils.addAttribute((Element)avatar, (String)"src", (String)avatarSource);
            DOM4JUtils.addAttribute((Element)avatar, (String)"alt", (String)"");
            container.add(avatar);
            Element link = DOM4JUtils.generateLinkElement((String)profileURL, null, null, null, (String)displayName);
            container.add(link);
            JspWriter out = pageContext.getOut();
            HTMLWriter htmlWriter = new HTMLWriter((Writer)out);
            htmlWriter.write(container);
        }
    }

    private String getUserProfilePageURL(NuxeoController nuxeoController, DirectoryPerson person) {
        String url;
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.ajaxLink", "1");
        properties.put("theme.dyna.partial_refresh_enabled", "true");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("uidFichePersonne", person.getUid());
        try {
            url = PORTAL_URL_FACTORY.getStartPageUrl(portalControllerContext, "userprofile", "/default/templates/userprofile", properties, parameters);
        }
        catch (PortalException e) {
            url = "";
        }
        return url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

