/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.lifecycle;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.faces.Bridge;
import org.jboss.portletbridge.application.PortletWindowState;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.portletbridge.richfaces.RichFacesHelper;

public class PortalPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = -4023885603543145666L;
    private RichFacesHelper ajaxContext;

    public PortalPhaseListener() {
        try {
            this.ajaxContext = new RichFacesHelper();
        }
        catch (NoClassDefFoundError e) {
            this.ajaxContext = null;
        }
    }

    public void afterPhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        FacesContext context = event.getFacesContext();
        Object portletPhase = context.getExternalContext().getRequestMap().get("javax.portlet.faces.phase");
        PortletWindowState windowState = null;
        PortletBridgeContext bridgeContext = (PortletBridgeContext)context.getExternalContext().getRequestMap().get(PortletBridgeContext.REQUEST_PARAMETER_NAME);
        if (null != bridgeContext) {
            windowState = bridgeContext.getWindowState();
        }
        if (phaseId.equals(PhaseId.RESTORE_VIEW)) {
            if (Bridge.PortletPhase.RenderPhase.equals(portletPhase)) {
                context.renderResponse();
            }
        } else if (phaseId.equals(PhaseId.RENDER_RESPONSE) && null != windowState) {
            windowState.saveSeamConversationId(context);
        }
    }

    public void beforePhase(PhaseEvent event) {
        PhaseId phaseId = event.getPhaseId();
        FacesContext context = event.getFacesContext();
        Object portletPhase = context.getExternalContext().getRequestMap().get("javax.portlet.faces.phase");
        if (null == portletPhase && phaseId.equals(PhaseId.RENDER_RESPONSE)) {
            PortletWindowState windowState = null;
            PortletBridgeContext bridgeContext = (PortletBridgeContext)context.getExternalContext().getRequestMap().get(PortletBridgeContext.REQUEST_PARAMETER_NAME);
            if (null != bridgeContext) {
                windowState = bridgeContext.getWindowState();
            }
            if (null != this.ajaxContext && null != windowState) {
                Map commonAjaxParameters = this.ajaxContext.getCurrentInstance(context).getCommonAjaxParameters();
                PortalActionURL pal = windowState.getPortalActionURL();
                if (null != pal) {
                    pal.setParameter("org.jboss.portletbridge.VIEWID", context.getViewRoot().getViewId());
                }
                commonAjaxParameters.put("javax.faces.portletbridge.STATE_ID", bridgeContext.getStateId().toString());
                commonAjaxParameters.put("org.ajax4jsf.portlet.NAMESPACE", windowState.getNamespace());
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

