/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import org.apache.commons.lang.BooleanUtils;

public class NuxeoCompatibility {
    private static boolean versionChecked = false;
    private static boolean esChecked = false;
    private static int currentVersion = 99;
    private static boolean isESActivated = false;
    public static int VERSION_58 = 58;
    public static int VERSION_60 = 60;

    public static boolean isVersionGreaterOrEqualsThan(int versionNumber) {
        if (!versionChecked) {
            versionChecked = true;
            String nuxeoVersion = System.getProperty("nuxeo.version");
            if (nuxeoVersion != null) {
                currentVersion = Integer.parseInt(nuxeoVersion);
            }
        }
        return currentVersion >= versionNumber;
    }

    public static boolean canUseES() {
        if (!esChecked) {
            boolean isNxVersionOk = NuxeoCompatibility.isVersionGreaterOrEqualsThan(VERSION_60);
            if (isNxVersionOk) {
                isESActivated = BooleanUtils.toBoolean((String)System.getProperty("nuxeo.es.activated"));
            }
            esChecked = true;
        }
        return isESActivated;
    }
}

