/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.osivia.portal.api.cache.services.CacheInfo;

public class VocabularyHelper {
    private static VocabularyEntry callCommand(NuxeoController ctx, List<String> vocabularyNames) {
        NuxeoController vocabCtx = new NuxeoController(ctx.getRequest(), ctx.getResponse(), ctx.getPortletCtx());
        vocabCtx.setCacheTimeOut(3600000L);
        vocabCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        vocabCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        VocabularyEntry vocab = (VocabularyEntry)vocabCtx.executeNuxeoCommand(new VocabularyLoaderCommand(vocabularyNames));
        return vocab;
    }

    public static String getVocabularyLabel(NuxeoController ctx, String vocabularyName, String key) {
        ArrayList<String> vocabs = new ArrayList<String>();
        vocabs.add(vocabularyName);
        return VocabularyHelper.getVocabularyLabel(ctx, vocabs, key);
    }

    public static String getVocabularyLabel(NuxeoController ctx, List<String> vocabs, String key) {
        VocabularyEntry child;
        VocabularyEntry vocab = VocabularyHelper.callCommand(ctx, vocabs);
        if (vocab != null && (child = vocab.getChild(key)) != null) {
            return vocab.getChild(key).getLabel();
        }
        return null;
    }

    public static VocabularyEntry getVocabularyEntry(NuxeoController ctx, String vocabularyName, String key) {
        ArrayList<String> vocabs = new ArrayList<String>();
        vocabs.add(vocabularyName);
        return VocabularyHelper.getVocabularyEntry(ctx, vocabs, key);
    }

    public static VocabularyEntry getVocabularyEntry(NuxeoController ctx, List<String> vocabs, String key) {
        VocabularyEntry vocab = VocabularyHelper.callCommand(ctx, vocabs);
        return vocab;
    }

    public static VocabularyEntry getVocabularyEntry(NuxeoController ctx, String vocabularyName) {
        ArrayList<String> vocabs = new ArrayList<String>();
        vocabs.add(vocabularyName);
        return VocabularyHelper.getVocabularyEntry(ctx, vocabs);
    }

    public static VocabularyEntry getVocabularyEntry(NuxeoController ctx, List<String> vocabs) {
        VocabularyEntry vocab = VocabularyHelper.callCommand(ctx, vocabs);
        return vocab;
    }

    private static class VocabularyLoaderCommand
    implements INuxeoCommand {
        List<String> vocabNames;
        String stringVocabNames = null;

        public VocabularyLoaderCommand(List<String> vocabNames) {
            this.vocabNames = vocabNames;
            this.stringVocabNames = "";
            for (String vocab : vocabNames) {
                if (this.stringVocabNames.length() > 0) {
                    this.stringVocabNames = this.stringVocabNames + ";";
                }
                this.stringVocabNames = this.stringVocabNames + vocab;
            }
        }

        private VocabularyEntry parseVocabularies(VocabularyEntry parent, JSONArray vocabulariesObj) throws UnsupportedEncodingException {
            VocabularyEntry entry = null;
            if (null == parent) {
                parent = new VocabularyEntry("root", "root");
            }
            if (!vocabulariesObj.isEmpty()) {
                for (JSONObject vocabulary : vocabulariesObj) {
                    String key = vocabulary.getString("key");
                    String label = vocabulary.getString("value");
                    if (label.startsWith("label.directories")) {
                        label = key;
                    }
                    String DecodedLabel = URLDecoder.decode(label, "UTF-8");
                    entry = new VocabularyEntry(key, DecodedLabel);
                    JSONArray children = null;
                    if (vocabulary.has("children") && null != (children = vocabulary.getJSONArray("children"))) {
                        this.parseVocabularies(entry, children);
                    }
                    parent.getChildren().put(entry.getId(), entry);
                }
            }
            return entry;
        }

        public boolean isAChild(String id, VocabularyEntry vocab) {
            for (Map.Entry<String, VocabularyEntry> entry : vocab.getChildren().entrySet()) {
                VocabularyEntry child = entry.getValue();
                if (!"key_root".equals(vocab.getId()) && id.equals(child.getId())) {
                    return true;
                }
                if (!this.isAChild(id, child)) continue;
                return true;
            }
            return false;
        }

        public void removeDuplicatedChilds(VocabularyEntry vocab) {
            ArrayList<String> removedEntries = new ArrayList<String>();
            for (Map.Entry<String, VocabularyEntry> entry : vocab.getChildren().entrySet()) {
                VocabularyEntry child = entry.getValue();
                if (!this.isAChild(child.getId(), vocab)) continue;
                removedEntries.add(child.getId());
            }
            for (String key : removedEntries) {
                vocab.getChildren().remove(key);
            }
        }

        @Override
        public Object execute(Session nuxeoSession) throws Exception {
            Blob blob = (Blob)nuxeoSession.newRequest("Document.GetVocabularies").setHeader("X-NXDocumentProperties", "*").set("vocabularies", (Object)this.stringVocabNames).set("locale", (Object)Locale.FRANCE.toString()).execute();
            String content = IOUtils.toString((InputStream)blob.getStream(), (String)"UTF-8");
            JSONObject rootObject = new JSONObject();
            rootObject.element("key", (Object)"key_root");
            rootObject.element("value", (Object)"value_root");
            rootObject.element("children", (Collection)JSONArray.fromObject((Object)content));
            JSONArray root = new JSONArray();
            root.element(rootObject);
            VocabularyEntry entries = this.parseVocabularies(null, root);
            this.removeDuplicatedChilds(entries);
            return entries;
        }

        @Override
        public String getId() {
            return this.stringVocabNames;
        }
    }
}

