/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.jboss.aop.AspectManager;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aop.annotation.AnnotationProxy;
import org.jboss.aop.util.ReflectToJavassist;

public class PortableAnnotationElement {
    public static boolean isInvisibleAnnotationPresent(Field field, String annotation) throws Exception {
        CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
        return AnnotationElement.isInvisibleAnnotationPresent(ctMethod, annotation);
    }

    public static boolean isInvisibleAnnotationPresent(CtField field, String annotation) {
        FieldInfo mi = field.getFieldInfo2();
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible == null) {
            return false;
        }
        return invisible.getAnnotation(annotation) != null;
    }

    public static boolean isVisibleAnnotationPresent(CtField field, String annotation) {
        FieldInfo mi = field.getFieldInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation) != null;
    }

    public static boolean isAnyAnnotationPresent(CtField ctField, String annotation) {
        FieldInfo mi = ctField.getFieldInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null && visible.getAnnotation(annotation) != null) {
            return true;
        }
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        return invisible != null && invisible.getAnnotation(annotation) != null;
    }

    public static boolean isInvisibleAnnotationPresent(Method method, String annotation) throws Exception {
        CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
        if (ctMethod == null) {
            return false;
        }
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible == null) {
            return false;
        }
        return invisible.getAnnotation(annotation) != null;
    }

    public static boolean isAnyAnnotationPresent(Field field, String annotation) throws Exception {
        CtField ctField = ReflectToJavassist.fieldToJavassist(field);
        return AnnotationElement.isAnyAnnotationPresent(ctField, annotation);
    }

    public static boolean isAnyAnnotationPresent(Method method, String annotation) throws Exception {
        CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
        if (ctMethod == null) {
            return false;
        }
        boolean present = AnnotationElement.isAnyAnnotationPresent(ctMethod, annotation);
        return present;
    }

    public static boolean isAnyAnnotationPresent(CtMethod ctMethod, String annotation) {
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null && visible.getAnnotation(annotation) != null) {
            return true;
        }
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        return invisible != null && invisible.getAnnotation(annotation) != null;
    }

    public static boolean isInvisibleAnnotationPresent(Constructor con, String annotation) throws Exception {
        CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
        return AnnotationElement.isInvisibleAnnotationPresent(ctMethod, annotation);
    }

    public static boolean isInvisibleAnnotationPresent(CtConstructor ctMethod, String annotation) {
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible == null) {
            return false;
        }
        return invisible.getAnnotation(annotation) != null;
    }

    public static boolean isVisibleAnnotationPresent(CtConstructor ctMethod, String annotation) {
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation) != null;
    }

    public static boolean isAnyAnnotationPresent(Constructor con, String annotation) throws Exception {
        CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
        return AnnotationElement.isAnyAnnotationPresent(ctMethod, annotation);
    }

    public static boolean isAnyAnnotationPresent(CtConstructor ctMethod, String annotation) {
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null && visible.getAnnotation(annotation) != null) {
            return true;
        }
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        return invisible != null && invisible.getAnnotation(annotation) != null;
    }

    public static boolean isInvisibleAnnotationPresent(Class clazz, String annotation) throws Exception {
        if (clazz == Void.TYPE) {
            return false;
        }
        ClassFile cf = AnnotationElement.getClassFile(clazz);
        AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible == null) {
            return false;
        }
        return invisible.getAnnotation(annotation) != null;
    }

    public static boolean isAnyAnnotationPresent(CtClass clazz, String annotation) throws Exception {
        if (clazz == CtClass.voidType) {
            return false;
        }
        ClassFile cf = clazz.getClassFile2();
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null && visible.getAnnotation(annotation) != null) {
            return true;
        }
        AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        return invisible != null && invisible.getAnnotation(annotation) != null;
    }

    public static boolean isAnyAnnotationPresent(Class clazz, String annotation) throws Exception {
        if (clazz == Void.TYPE) {
            return false;
        }
        ClassFile cf = AnnotationElement.getClassFile(clazz);
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null && visible.getAnnotation(annotation) != null) {
            return true;
        }
        AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        return invisible != null && invisible.getAnnotation(annotation) != null;
    }

    protected static ClassFile getClassFile(Class clazz) throws NotFoundException {
        ClassPool pool = AspectManager.instance().findClassPool(clazz.getClassLoader());
        CtClass ct = pool.get(clazz.getName());
        ClassFile cf = ct.getClassFile2();
        return cf;
    }

    protected static Object create(AnnotationsAttribute group, Class annotation) throws Exception {
        if (group == null) {
            return null;
        }
        Annotation info = group.getAnnotation(annotation.getName());
        if (info == null) {
            return null;
        }
        return AnnotationProxy.createProxy(info, annotation);
    }

    public static Object getInvisibleAnnotation(Method method, Class annotation) {
        try {
            CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
            if (ctMethod == null) {
                return null;
            }
            MethodInfo mi = ctMethod.getMethodInfo2();
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return null;
            }
            return PortableAnnotationElement.create(invisible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInvisibleAnnotation(Constructor con, Class annotation) {
        try {
            CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
            MethodInfo mi = ctMethod.getMethodInfo2();
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return null;
            }
            return PortableAnnotationElement.create(invisible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInvisibleAnnotation(Field field, Class annotation) {
        try {
            CtField ctField = ReflectToJavassist.fieldToJavassist(field);
            FieldInfo mi = ctField.getFieldInfo2();
            AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return null;
            }
            return PortableAnnotationElement.create(invisible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getInvisibleAnnotation(Class clazz, Class annotation) {
        try {
            if (clazz == Void.TYPE) {
                return null;
            }
            ClassFile cf = PortableAnnotationElement.getClassFile(clazz);
            AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
            if (invisible == null) {
                return null;
            }
            return PortableAnnotationElement.create(invisible, annotation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getAnyAnnotation(Method method, Class annotation) {
        Object rtn = AnnotationElement.getVisibleAnnotation(method, annotation);
        if (rtn != null) {
            return rtn;
        }
        return PortableAnnotationElement.getInvisibleAnnotation(method, annotation);
    }

    public static Object getAnyAnnotation(Constructor con, Class annotation) {
        Object rtn = AnnotationElement.getVisibleAnnotation(con, annotation);
        if (rtn != null) {
            return rtn;
        }
        return PortableAnnotationElement.getInvisibleAnnotation(con, annotation);
    }

    public static Object getAnyAnnotation(Field field, Class annotation) {
        Object rtn = AnnotationElement.getVisibleAnnotation(field, annotation);
        if (rtn != null) {
            return rtn;
        }
        return PortableAnnotationElement.getInvisibleAnnotation(field, annotation);
    }

    public static Object getAnyAnnotation(Class clazz, Class annotation) {
        if (clazz == Void.TYPE) {
            return null;
        }
        Object rtn = AnnotationElement.getVisibleAnnotation(clazz, annotation);
        if (rtn != null) {
            return rtn;
        }
        return PortableAnnotationElement.getInvisibleAnnotation(clazz, annotation);
    }

    public static boolean isAnyAnnotationPresent(Field field, Class annotation) throws Exception {
        if (AnnotationElement.isVisibleAnnotationPresent(field, annotation)) {
            return true;
        }
        CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
        return PortableAnnotationElement.isInvisibleAnnotationPresent(ctMethod, annotation.getName());
    }

    public static boolean isAnyAnnotationPresent(Class clazz, Class annotation) throws Exception {
        if (clazz == Void.TYPE) {
            return false;
        }
        if (AnnotationElement.isVisibleAnnotationPresent(clazz, annotation)) {
            return true;
        }
        ClassFile cf = PortableAnnotationElement.getClassFile(clazz);
        AnnotationsAttribute invisible = (AnnotationsAttribute)cf.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible == null) {
            return false;
        }
        return invisible.getAnnotation(annotation.getName()) != null;
    }

    public static boolean isAnyAnnotationPresent(Constructor con, Class annotation) throws Exception {
        if (AnnotationElement.isVisibleAnnotationPresent(con, annotation)) {
            return true;
        }
        CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
        return PortableAnnotationElement.isVisibleAnnotationPresent(ctMethod, annotation.getName());
    }

    public static boolean isAnyAnnotationPresent(Method method, Class annotation) throws Exception {
        if (AnnotationElement.isVisibleAnnotationPresent(method, annotation)) {
            return true;
        }
        CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
        if (ctMethod == null) {
            return false;
        }
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
        if (invisible == null) {
            return false;
        }
        return invisible.getAnnotation(annotation.getName()) != null;
    }

    public static boolean isVisibleAnnotationPresent(Field field, String annotation) throws Exception {
        CtField ctMethod = ReflectToJavassist.fieldToJavassist(field);
        return PortableAnnotationElement.isVisibleAnnotationPresent(ctMethod, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Class clazz, String annotation) throws Exception {
        if (clazz == Void.TYPE) {
            return false;
        }
        ClassFile cf = PortableAnnotationElement.getClassFile(clazz);
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation) != null;
    }

    public static boolean isVisibleAnnotationPresent(Constructor con, String annotation) throws Exception {
        CtConstructor ctMethod = ReflectToJavassist.constructorToJavassist(con);
        return PortableAnnotationElement.isVisibleAnnotationPresent(ctMethod, annotation);
    }

    public static boolean isVisibleAnnotationPresent(Method method, String annotation) throws Exception {
        CtMethod ctMethod = ReflectToJavassist.methodToJavassist(method);
        if (ctMethod == null) {
            return false;
        }
        MethodInfo mi = ctMethod.getMethodInfo2();
        AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
        if (visible == null) {
            return false;
        }
        return visible.getAnnotation(annotation) != null;
    }

    public static Object[] getVisibleAnnotations(Class clazz) throws Exception {
        return AnnotationElement.getVisibleAnnotations(clazz);
    }

    public static Object[] getVisibleAnnotations(Method m) throws Exception {
        return AnnotationElement.getVisibleAnnotations(m);
    }

    public static Object[] getVisibleAnnotations(Field f) throws Exception {
        return AnnotationElement.getVisibleAnnotations(f);
    }

    public static Object[] getVisibleAnnotations(Constructor c) throws Exception {
        return AnnotationElement.getVisibleAnnotations(c);
    }

    public static Class getAnnotationType(Object o) {
        Class<?>[] interfaces;
        Class<?> proxy = o.getClass();
        if (Proxy.isProxyClass(proxy) && (interfaces = proxy.getInterfaces()).length == 1) {
            return interfaces[0];
        }
        return null;
    }
}

