/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jboss.portal.common.util.Tools;

public class BufferingRequestWrapper
extends HttpServletRequestWrapper {
    private static final Object REMOVED_ATTRIBUTE = new Object();
    private Map attributes;
    private Locale[] locales;
    private String contextPath;

    public BufferingRequestWrapper(HttpServletRequest servletRequest, String contextPath, Locale[] locales) {
        super(servletRequest);
        this.contextPath = contextPath;
        this.locales = locales;
        this.attributes = new HashMap();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Locale getLocale() {
        return this.locales.length > 0 ? this.locales[0] : null;
    }

    public Enumeration getLocales() {
        return Tools.toEnumeration(this.locales);
    }

    public String getMethod() {
        return "GET";
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            value = REMOVED_ATTRIBUTE;
        }
        this.attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        Object value = this.attributes.get(name);
        if (value == REMOVED_ATTRIBUTE) {
            value = null;
        } else if (value == null) {
            value = this.getRequest().getAttribute(name);
        }
        return value;
    }

    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    public Enumeration getAttributeNames() {
        HashSet names = new HashSet();
        Enumeration e = this.getRequest().getAttributeNames();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        for (Map.Entry entry : this.attributes.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == REMOVED_ATTRIBUTE) {
                names.remove(name);
                continue;
            }
            names.add(name);
        }
        return Tools.toEnumeration(names.iterator());
    }
}

