/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.gui;

import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.faces.gui.BeanContext;

public abstract class ManagedBean {
    protected Logger log = Logger.getLogger(this.getClass());
    protected BeanContext beanContext;
    public static final String INVALID_NAME = "INVALID_NAME_ERROR";
    public static final String DUPLICATE = "DUPLICATE_ERROR";

    public void setBeanContext(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public String checkNameValidity(String name, String targetForErrorMessage) {
        if (ParameterValidation.isNullOrEmpty((String)name)) {
            this.beanContext.createTargetedErrorMessage(targetForErrorMessage, INVALID_NAME, name, this.getLocalizedType());
            return null;
        }
        name = name.trim();
        if ((name = ParameterValidation.sanitizeFromPatternWithHandler((String)name, (Pattern)ParameterValidation.XSS_CHECK, (ParameterValidation.ValidationErrorHandler)new MessageValidationHandler(null, targetForErrorMessage, name))) == null) {
            return null;
        }
        if (this.isAlreadyExisting(name)) {
            this.beanContext.createTargetedErrorMessage(targetForErrorMessage, DUPLICATE, name, this.getLocalizedType());
            return null;
        }
        return name;
    }

    private String getLocalizedType() {
        return this.beanContext.getMessageFromBundle(this.getObjectTypeName(), new Object[0]);
    }

    protected abstract String getObjectTypeName();

    public abstract boolean isAlreadyExisting(String var1);

    public boolean isOldAndNewDifferent(Object oldValue, Object newValue) {
        oldValue = this.normalizeStringIfNeeded(oldValue);
        newValue = this.normalizeStringIfNeeded(newValue);
        return oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null;
    }

    public Object normalizeStringIfNeeded(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return stringValue.length() == 0 ? null : stringValue.trim();
        }
        return value;
    }

    private class MessageValidationHandler
    extends ParameterValidation.ValidationErrorHandler {
        private String targetForErrorMessage;
        private String validatedName;

        private MessageValidationHandler(String defaultValue, String targetForErrorMessage, String validatedName) {
            super(defaultValue);
            this.targetForErrorMessage = targetForErrorMessage;
            this.validatedName = validatedName;
        }

        protected String internalValidationErrorHandling(String s) {
            ManagedBean.this.beanContext.createTargetedErrorMessage(this.targetForErrorMessage, ManagedBean.INVALID_NAME, this.validatedName, ManagedBean.this.getLocalizedType());
            return null;
        }
    }
}

