/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.displaytag;

import javax.servlet.jsp.PageContext;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.TableModel;
import org.dom4j.Element;
import org.osivia.portal.api.html.DOM4JUtils;

public class SortableTableDecorator
extends TableDecorator {
    public void init(PageContext pageContext, Object decorated, TableModel tableModel) {
        super.init(pageContext, decorated, tableModel);
        if (tableModel.isSorted()) {
            HeaderCell sortedHeaderCell = tableModel.getSortedColumnHeader();
            boolean ascending = tableModel.isSortOrderAscending();
            this.addSortedHeaderIcon(sortedHeaderCell, ascending);
        }
    }

    protected void addSortedHeaderIcon(HeaderCell sortedHeaderCell, boolean ascending) {
        String glyphicons = ascending ? "halflings halflings-sort-by-attributes" : "halflings halflings-sort-by-attributes-alt";
        Element element = DOM4JUtils.generateElement("span", null, sortedHeaderCell.getTitle());
        element.add(DOM4JUtils.generateElement("span", null, null, glyphicons, null));
        sortedHeaderCell.setTitle(DOM4JUtils.write(element));
    }
}

