/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.net;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.osivia.portal.api.PortalException;

public abstract class ProxyUtils {
    public static void setProxyConfiguration(String url, HttpClient client) throws PortalException {
        ProxyConfig proxyConf = ProxyUtils.getProxyConfigFromEnvProperties();
        try {
            if (ProxyUtils.isProxyEnabled(new URL(url), proxyConf.getHost())) {
                HostConfiguration configuration = new HostConfiguration();
                configuration.setProxy(proxyConf.getHost(), proxyConf.getPort());
                client.setHostConfiguration(configuration);
                ProxyCredentials identity = ProxyUtils.getProxyUserFromEnvProperties();
                String proxyUser = identity.getUserName();
                String domain = identity.getDomain();
                String proxyPassword = identity.getUserPassword();
                if (proxyUser != null) {
                    Object credentials = domain != null ? new NTCredentials(proxyUser, proxyPassword, "", "") : new UsernamePasswordCredentials(proxyUser, proxyPassword);
                    client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new PortalException(e);
        }
    }

    private static boolean validateNonProxyHosts(String targetHost) {
        return ProxyUtils.isNotProxyHost(targetHost);
    }

    public static boolean isProxyEnabled(URL targetURL, String proxyHost) {
        boolean state = false;
        if (proxyHost != null) {
            state = true;
        }
        boolean isNonProxyHost = ProxyUtils.validateNonProxyHosts(targetURL.getHost());
        return state && !isNonProxyHost;
    }

    public static boolean isNotProxyHost(String targetHost) {
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (nonProxyHosts == null) {
            return false;
        }
        String[] nonProxyHostsArray = nonProxyHosts.split("\\|");
        if (nonProxyHostsArray.length == 1) {
            return targetHost.matches(nonProxyHosts);
        }
        boolean pass = false;
        for (int i = 0; i < nonProxyHostsArray.length; ++i) {
            String a = nonProxyHostsArray[i];
            if (!targetHost.matches(a)) continue;
            pass = true;
            break;
        }
        return pass;
    }

    public static ProxyConfig getProxyConfigFromEnvProperties() {
        return new ProxyConfig(System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"));
    }

    public static ProxyCredentials getProxyUserFromEnvProperties() {
        int separatorIndex;
        String domain = System.getProperty("http.auth.ntlm.domain");
        String userName = System.getProperty("http.proxyUser");
        String userPassword = System.getProperty("http.proxyPassword");
        if (userName != null && (separatorIndex = userName.indexOf(92)) != -1) {
            String completeName = userName;
            userName = completeName.substring(separatorIndex + 1);
            if (ProxyUtils.isEmpty(domain)) {
                domain = completeName.substring(0, separatorIndex);
            }
        }
        return new ProxyCredentials(userName, userPassword, domain);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static class ProxyCredentials {
        private String userName;
        private String domain;
        private String userPassword;

        public ProxyCredentials(String userName, String userPassword, String domain) {
            this.userName = userName;
            this.domain = domain;
            this.userPassword = userPassword;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getUserPassword() {
            return this.userPassword;
        }
    }

    public static class ProxyConfig {
        private String host;
        private int port = -1;

        public ProxyConfig(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public ProxyConfig(String host, String port) {
            this(host, ProxyConfig.getPortAsInt(port));
        }

        public static int getPortAsInt(String sPort) {
            int port = -1;
            try {
                if (sPort != null) {
                    port = Integer.parseInt(sPort);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

