/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.deployment;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.server.deployment.PortalWebApp;
import org.jboss.portal.server.deployment.PortalWebAppFactory;
import org.jboss.web.WebApplication;
import org.osivia.portal.api.deployment.DeploymentContext;
import org.xml.sax.EntityResolver;

public abstract class WebAppIntercepter
extends AbstractJBossService
implements NotificationListener {
    private ObjectName interceptedDeployer;
    private ObjectName currentInterceptedDeployer;
    private Map deployments = Collections.synchronizedMap(new HashMap());
    private PortalWebAppFactory factory;
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private EntityResolver jbossAppEntityResolver;

    public EntityResolver getJBossAppEntityResolver() {
        return this.jbossAppEntityResolver;
    }

    public void setJBossAppEntityResolver(EntityResolver jbossAppEntityResolver) {
        this.jbossAppEntityResolver = jbossAppEntityResolver;
    }

    public void setInterceptedDeployer(ObjectName interceptedDeployer) {
        this.interceptedDeployer = interceptedDeployer;
    }

    public ObjectName getInterceptedDeployer() {
        return this.interceptedDeployer;
    }

    public Collection getDeployedURLs() {
        return new ArrayList(this.deployments.keySet());
    }

    private WebApplication findWebApp(DeploymentInfo info) throws Exception {
        Iterator iterator = (Iterator)this.server.getAttribute(this.interceptedDeployer, "DeployedApplications");
        while (iterator.hasNext()) {
            WebApplication webApp = (WebApplication)iterator.next();
            if (info != webApp.getDeploymentInfo()) continue;
            return webApp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        boolean start = "org.jboss.deployment.SubDeployer.start".equals(type);
        boolean stop = "org.jboss.deployment.SubDeployer.stop".equals(type);
        if (start || stop) {
            ClassLoader previousLoader = Thread.currentThread().getContextClassLoader();
            try {
                PortalWebApp pwa;
                Thread.currentThread().setContextClassLoader(this.classLoader);
                DeploymentInfo info = (DeploymentInfo)notification.getUserData();
                URL keyURL = info.url;
                if (start) {
                    WebApplication webApp = this.findWebApp(info);
                    PortalWebApp pwa2 = this.factory.create(webApp, this.jbossAppEntityResolver);
                    this.deployments.put(keyURL, pwa2);
                    this.log.debug((Object)("Seen URL " + keyURL + " about to deploy"));
                    this.deploy(pwa2);
                }
                if (stop && (pwa = (PortalWebApp)this.deployments.remove(keyURL)) != null) {
                    this.log.debug((Object)("Undeploying URL " + keyURL));
                    this.undeploy(pwa);
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Cannot handle the intercepted deployment", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousLoader);
            }
        }
    }

    protected void startService() throws Exception {
        String curContext = (String)DeploymentContext.getContext().get("osivia.portlet.currentContext");
        if (this.interceptedDeployer != null) {
            this.factory = new PortalWebAppFactory(this.server);
            this.currentInterceptedDeployer = this.interceptedDeployer;
            this.log.debug((Object)("Start listening notifications from intercepted deployer" + this.currentInterceptedDeployer));
            this.server.addNotificationListener(this.currentInterceptedDeployer, this, null, null);
            Iterator iterator = (Iterator)this.server.getAttribute(this.currentInterceptedDeployer, "DeployedApplications");
            this.log.debug((Object)"Scan previously deployed web applications");
            while (iterator.hasNext()) {
                WebApplication webApp = (WebApplication)iterator.next();
                URL keyURL = webApp.getDeploymentInfo().url;
                if (StringUtils.equals((String)curContext, (String)webApp.getMetaData().getContextRoot())) {
                    this.log.debug((Object)("Avoir reentrancy" + curContext));
                    continue;
                }
                if (this.deployments.containsKey(keyURL)) continue;
                PortalWebApp pwa = this.factory.create(webApp, this.jbossAppEntityResolver);
                this.deployments.put(keyURL, pwa);
                this.log.debug((Object)("Seen URL " + keyURL + " about to deploy"));
                this.deploy(pwa);
            }
        } else {
            throw new Exception("No intercepted deployer name present");
        }
    }

    protected void stopService() throws Exception {
        String curContext = (String)DeploymentContext.getContext().get("osivia.portlet.currentContext");
        if (this.currentInterceptedDeployer != null) {
            Iterator i = this.deployments.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                URL keyURL = (URL)entry.getKey();
                PortalWebApp pwa = (PortalWebApp)entry.getValue();
                if (StringUtils.equals((String)curContext, (String)pwa.getContextPath())) {
                    this.log.debug((Object)("Avoir reentrancy" + curContext));
                    continue;
                }
                i.remove();
                this.log.debug((Object)("Removing web application with URL " + keyURL));
                this.undeploy(pwa);
            }
            this.log.debug((Object)("Stop listening notifications from intercepted deployer" + this.currentInterceptedDeployer));
            this.server.removeNotificationListener(this.currentInterceptedDeployer, this);
            this.factory = null;
            this.currentInterceptedDeployer = null;
        }
    }

    protected abstract void deploy(PortalWebApp var1);

    protected abstract void undeploy(PortalWebApp var1);
}

