/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.request;

public final class URLFormat {
    public static final int RELATIVE_MASK = 1;
    public static final int SERVLET_ENCODED_MASK = 2;
    private static final URLFormat[] formats = new URLFormat[]{new URLFormat(false, false), new URLFormat(true, false), new URLFormat(false, true), new URLFormat(true, true)};
    private final int mask;
    private final boolean relative;
    private final boolean servletEncoded;

    private URLFormat(boolean relative, boolean encoded) {
        this.mask = (relative ? 1 : 0) | (encoded ? 2 : 0);
        this.relative = relative;
        this.servletEncoded = encoded;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public boolean isServletEncoded() {
        return this.servletEncoded;
    }

    public int getMask() {
        return this.mask;
    }

    public static URLFormat newInstance(int mask) {
        return formats[mask];
    }

    public static URLFormat newInstance(boolean relative, boolean encoded) {
        int mask = (relative ? 1 : 0) | (encoded ? 2 : 0);
        return formats[mask];
    }
}

