/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.NoSuchResourceException;
import org.jboss.portal.core.controller.SecurityException;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.controller.command.info.ViewCommandInfo;
import org.jboss.portal.core.controller.portlet.ControllerPageNavigationalState;
import org.jboss.portal.core.controller.portlet.ControllerPortletControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.PageCommand;
import org.jboss.portal.core.model.portal.command.render.RenderWindowCommand;
import org.jboss.portal.core.model.portal.command.response.MarkupResponse;
import org.jboss.portal.core.model.portal.content.WindowRendition;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateKey;
import org.jboss.portal.core.theme.PageRendition;
import org.jboss.portal.core.theme.WindowContextFactory;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.PageService;
import org.jboss.portal.theme.PortalLayout;
import org.jboss.portal.theme.PortalTheme;
import org.jboss.portal.theme.ThemeService;
import org.jboss.portal.theme.page.PageResult;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.mt.IMultithreadService;
import org.osivia.portal.core.profils.IProfilManager;

public final class RenderPageCommand
extends PageCommand {
    private static final CommandInfo info = new ViewCommandInfo();
    private Collection<PortalObject> windows;
    private boolean personalizable;
    protected static final Log logger = LogFactory.getLog(RenderPageCommand.class);
    private IProfilManager profilManager = null;

    public RenderPageCommand(PortalObjectId pageId) {
        super(pageId);
    }

    public CommandInfo getInfo() {
        return info;
    }

    public Collection getWindows() {
        return this.windows;
    }

    public void acquireResources() throws NoSuchResourceException {
        super.acquireResources();
        this.windows = new ArrayList<PortalObject>(this.getPage().getChildren(8));
    }

    protected IProfilManager getProfilManager() throws Exception {
        if (this.profilManager == null) {
            this.profilManager = (IProfilManager)Locator.findMBean(IProfilManager.class, (String)"osivia:service=ProfilManager");
        }
        return this.profilManager;
    }

    protected Page initPage() {
        return (Page)this.getTarget();
    }

    public void enforceSecurity(PortalAuthorizationManager pam) throws SecurityException {
        super.enforceSecurity(pam);
    }

    public ControllerResponse execute() throws ControllerException, InvocationException {
        try {
            Object pageResult;
            ControllerContext controllerCtx;
            User user;
            PageService pageService = this.context.getController().getPageService();
            ThemeService themeService = pageService.getThemeService();
            LayoutService layoutService = pageService.getLayoutService();
            PortalLayout layout = RenderPageCommand.getLayout(layoutService, this.page);
            PortalTheme theme = null;
            ControllerPortletControllerContext portletControllerContext = new ControllerPortletControllerContext(this.context, this.page);
            ControllerPageNavigationalState pageNavigationalState = portletControllerContext.getStateControllerContext().createPortletPageNavigationalState(true);
            if (this.personalizable && (user = (controllerCtx = (ControllerContext)this.getContext()).getUser()) != null) {
                UserProfileModule userProfileModule = null;
                try {
                    userProfileModule = (UserProfileModule)new InitialContext().lookup("java:portal/UserProfileModule");
                }
                catch (NamingException ignore) {
                    // empty catch block
                }
                Map profile = (Map)this.getContext().getAttribute(ServerInvocation.PRINCIPAL_SCOPE, (Object)"profile");
                String themeId = null;
                themeId = profile == null ? (String)userProfileModule.getProperty(user, "portal.user.theme") : (String)profile.get("portal.user.theme");
                if (themeId != null) {
                    theme = themeService.getThemeById(themeId);
                }
            }
            if (theme == null) {
                String themeId = this.page.getProperty("theme.id");
                theme = themeService.getThemeById(themeId);
            }
            if (this.getControllerContext().getAttribute(Scope.PRINCIPAL_SCOPE, "osivia.popupMode") != null) {
                layout = layoutService.getLayoutById("osivia-popup");
                theme = themeService.getThemeById("osivia-popup");
            }
            InitialContext initialContext = new InitialContext();
            IMultithreadService multithreadService = (IMultithreadService)initialContext.lookup("java:multithread");
            boolean isMultiThreadEnabled = true;
            if ("false".equals(System.getProperty("portlets.enableMultiThread"))) {
                isMultiThreadEnabled = false;
            }
            Set visibleRegions = (Set)this.getControllerContext().getAttribute(Scope.REQUEST_SCOPE, "osivia.layout.visibleRegions");
            String visibleRegionsLayoutState = (String)this.getControllerContext().getAttribute(Scope.REQUEST_SCOPE, "osivia.layout.visibleRegions.parserState");
            Object warningMsg = null;
            ArrayList<Window> filteredWindows = new ArrayList<Window>();
            if (this.getControllerContext().getAttribute(Scope.PRINCIPAL_SCOPE, "osivia.popupMode") != null) {
                isMultiThreadEnabled = false;
            }
            for (PortalObject window : this.windows) {
                String region;
                String string;
                if (!(window instanceof Window)) continue;
                boolean addWindow = true;
                if (this.getControllerContext().getAttribute(Scope.PRINCIPAL_SCOPE, "osivia.popupMode") != null) {
                    PortalObjectId portalObjectId;
                    if (this.getControllerContext().getServerInvocation().getServerContext().getClientRequest().getAttribute("osivia.popupModeClosing") != null) {
                        addWindow = false;
                    }
                    if ((portalObjectId = (PortalObjectId)((ControllerContext)this.getContext()).getAttribute(ControllerCommand.PRINCIPAL_SCOPE, "osivia.popupModeWindowID")) != null && !window.getId().equals(portalObjectId)) {
                        addWindow = false;
                    }
                }
                if ((string = window.getProperty("osivia.conditionalScope")) != null) {
                    addWindow = false;
                    ControllerContext controllerCtx2 = (ControllerContext)this.getContext();
                    Boolean isAdmin = (Boolean)controllerCtx2.getAttribute(Scope.PRINCIPAL_SCOPE, "osivia.isAdmin");
                    if (isAdmin != null && isAdmin.booleanValue()) {
                        addWindow = true;
                    }
                    if (!addWindow) {
                        addWindow = this.getProfilManager().verifierProfilUtilisateur(string);
                    }
                }
                if (addWindow && visibleRegions != null && !visibleRegions.contains(region = window.getDeclaredProperty("theme.region"))) {
                    NavigationalStateKey nsKey = new NavigationalStateKey(WindowNavigationalState.class, window.getId());
                    WindowNavigationalState windowNavState = (WindowNavigationalState)((ControllerContext)this.getContext()).getAttribute(ControllerCommand.NAVIGATIONAL_STATE_SCOPE, nsKey);
                    if (windowNavState == null || !WindowState.MAXIMIZED.equals((Object)windowNavState.getWindowState())) {
                        if (StringUtils.equals((String)"virtual", (String)region)) {
                            addWindow = false;
                        } else if (StringUtils.equals((String)"maximized", (String)visibleRegionsLayoutState)) {
                            addWindow = false;
                        } else if (!StringUtils.equals((String)window.getName(), (String)"menuBarWindow")) {
                            log.warn((Object)("this window seems not to be present in any visible region, should check ... : " + window.getId().toString(PortalObjectPath.CANONICAL_FORMAT)));
                        }
                    }
                }
                if (!addWindow) continue;
                filteredWindows.add((Window)window);
            }
            if (multithreadService != null && isMultiThreadEnabled) {
                pageResult = multithreadService.execute(this.page, this.context, filteredWindows, layout, theme, pageService, pageNavigationalState);
                return pageResult;
            }
            pageResult = new PageResult(this.getPage().getName(), new HashMap<String, String>(this.getPage().getProperties()));
            WindowContextFactory wcFactory = new WindowContextFactory(this.context);
            for (PortalObject portalObject : filteredWindows) {
                ControllerResponse response;
                if (!(portalObject instanceof Window)) continue;
                Window window = (Window)portalObject;
                RenderWindowCommand renderCmd = new RenderWindowCommand(pageNavigationalState, window.getId());
                WindowRendition rendition = null;
                if (renderCmd != null) {
                    rendition = renderCmd.render(this.context);
                }
                if (rendition == null || (response = rendition.getControllerResponse()) == null) continue;
                if (response instanceof MarkupResponse) {
                    pageResult.addWindowContext(wcFactory.createWindowContext(window, rendition));
                    continue;
                }
                if (response == null) continue;
                return response;
            }
            return new PageRendition(layout, theme, (PageResult)pageResult, pageService);
        }
        catch (Exception e) {
            RenderPageCommand.rethrow(e);
            return null;
        }
    }

    public static PortalLayout getLayout(LayoutService layoutService, Page page) {
        String layoutIdString = page.getProperty("layout.id");
        return layoutService.getLayoutById(layoutIdString);
    }
}

