/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.validators;

import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.portlet.PortletContext;
import org.jboss.logging.Logger;
import org.jboss.portal.core.identity.services.metadata.CoreIdentityConfigurationException;
import org.jboss.portal.core.identity.services.workflow.RegistrationService;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;

public class UsernameValidator
implements Validator {
    private UserModule userModule;
    private RegistrationService registrationService;
    private static final Logger log = Logger.getLogger(UsernameValidator.class);

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String username = (String)value;
        ResourceBundle bundle = ResourceBundle.getBundle("conf.bundles.Identity", context.getViewRoot().getLocale());
        PortletContext portletContext = (PortletContext)context.getExternalContext().getContext();
        this.userModule = (UserModule)portletContext.getAttribute("UserModule");
        this.registrationService = (RegistrationService)portletContext.getAttribute("RegistrationService");
        try {
            if (this.registrationService.checkUsername(username)) {
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_TAKEN"), bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_TAKEN")));
            }
            User u = this.userModule.findUserByUserName(username);
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_TAKEN"), bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_TAKEN")));
        }
        catch (NoSuchUserException e) {
        }
        catch (IllegalArgumentException e) {
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_ERROR"), bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_ERROR")));
        }
        catch (IdentityException e) {
            log.error((Object)"Error validation username", (Throwable)e);
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_ERROR"), bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_ERROR")));
        }
        catch (CoreIdentityConfigurationException e) {
            log.error((Object)"Error validation username", (Throwable)e);
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_ERROR"), bundle.getString("IDENTITY_VALIDATION_ERROR_USERNAME_ERROR")));
        }
    }
}

