/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.coordination;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.portal.common.util.ParameterValidation;
import org.jboss.portal.core.controller.coordination.AliasBindingInfo;
import org.jboss.portal.core.controller.coordination.CoordinationConfigurator;
import org.jboss.portal.core.controller.coordination.CoordinationManager;
import org.jboss.portal.core.controller.coordination.EventConverter;
import org.jboss.portal.core.controller.coordination.EventWiringInfo;
import org.jboss.portal.core.controller.coordination.IllegalCoordinationException;
import org.jboss.portal.core.controller.coordination.ParameterBindingInfo;
import org.jboss.portal.core.controller.coordination.Utils;
import org.jboss.portal.core.controller.portlet.ControllerPortletControllerContext;
import org.jboss.portal.core.impl.coordination.SimpleEventConverter;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PageContainer;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.portlet.controller.event.PortletWindowEvent;
import org.jboss.portal.portlet.info.EventInfo;
import org.jboss.portal.portlet.info.PortletInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordinationService
extends AbstractJBossService
implements CoordinationManager,
CoordinationConfigurator {
    private static final String EVENT_ROLE_SOURCE = "source";
    private static final String EVENT_ROLE_DESTINATION = "destination";
    public static final String BINDING = "binding";
    public static final String PREFIX = "coordination";
    public static final String QNAME_SEPARATOR = ";";
    public static final String PREFIX_EVENT = "coordination.event";
    public static final String EVENT_IMPLICIT_MODE = "coordination.event.implicit_mode";
    public static final String PREFIX_EVENT_NAME = "coordination.event.name.";
    public static final String PREFIX_EVENT_WIRING = "coordination.event.wiring.";
    private static final int PREFIX_EVENT_NAME_LENGTH = "coordination.event.name.".length();
    public static final String PREFIX_PARAMETER = "coordination.parameter";
    public static final String PARAMETER_IMPLICIT_MODE = "coordination.parameter.implicit_mode";
    public static final String PREFIX_PARAMETER_NAME = "coordination.parameter.name.";
    public static final String PREFIX_PARAMETER_BINDING = "coordination.parameter.binding.";
    private static final int PREFIX_PARAMETER_BINDING_LENGTH = "coordination.parameter.binding.".length();
    public static final String PREFIX_PARAMETER_ALIAS = "coordination.parameter.alias";
    public static final String PREFIX_PARAMETER_ALIAS_NAME = "coordination.parameter.alias.name.";
    private static final int PREFIX_PARAMETER_ALIAS_LENGTH = "coordination.parameter.alias.name.".length();
    public static final Boolean DEFAULT_IMPLICIT_MODE = true;
    protected EventConverter eventConverter = new SimpleEventConverter();
    protected PortalObjectContainer portalObjectContainer;

    protected void startService() throws Exception {
        super.startService();
        if (this.portalObjectContainer == null) {
            throw new IllegalStateException("Cannot instantiate CoordinationManager: no PortalObjectContainer present");
        }
    }

    @Override
    public Map<Window, PortletWindowEvent> getEventWindows(PortletWindowEvent event, ControllerPortletControllerContext context) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)event, (String)"event");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)context, (String)"context");
        Page page = context.getWindow(event.getWindowId()).getPage();
        boolean implicitMode = this.resolveEventWiringImplicitModeEnabled(page);
        Map<Window, PortletWindowEvent> windows = this.getEventWindowsExplicit(page, event, context);
        if (implicitMode && windows.size() == 0) {
            windows = this.getEventWindowsImplicit(page, event, context);
        }
        return windows;
    }

    @Override
    public Collection<String> getBindingNames(Window window, QName name) {
        HashSet<String> names = new HashSet<String>();
        for (ParameterBindingInfo parameterBindingInfo : this.getParameterBindings(window)) {
            for (Map.Entry<Window, Set<QName>> entry : parameterBindingInfo.getMappings().entrySet()) {
                if (!entry.getKey().getName().equals(window.getName())) continue;
                for (QName qName : entry.getValue()) {
                    if (!name.equals(qName)) continue;
                    names.add(parameterBindingInfo.getName());
                }
            }
        }
        if (names.isEmpty()) {
            for (AliasBindingInfo aliasBindingInfo : this.getAliasBindings(window.getPage())) {
                if (!aliasBindingInfo.getParameterNames().contains(name)) continue;
                names.add(aliasBindingInfo.getName());
            }
        }
        return names;
    }

    private Map<Window, PortletWindowEvent> getEventWindowsExplicit(Page page, PortletWindowEvent event, ControllerPortletControllerContext context) {
        HashMap<Window, PortletWindowEvent> windows = new HashMap<Window, PortletWindowEvent>();
        Collection<EventWiringInfo> infos = this.getEventWirings(page);
        block0: for (EventWiringInfo info : infos) {
            for (Map.Entry<Window, QName> entry : info.getSources().entrySet()) {
                if (!entry.getKey().getName().equals(event.getWindowId()) || !entry.getValue().equals(event.getName())) continue;
                for (Window window : info.getDestinations().keySet()) {
                    PortletInfo portletInfo = context.getPortletInfo(window.getName());
                    QName destEventName = info.getDestinations().get(window);
                    EventInfo destEventInfo = (EventInfo)portletInfo.getEventing().getConsumedEvents().get(destEventName);
                    if (destEventInfo == null) continue;
                    windows.put(window, this.getEventConverter().convertEvent(event, destEventInfo, window));
                }
                continue block0;
            }
        }
        return windows;
    }

    private Map<Window, PortletWindowEvent> getEventWindowsImplicit(Page page, PortletWindowEvent event, ControllerPortletControllerContext context) {
        HashMap<Window, PortletWindowEvent> windows = new HashMap<Window, PortletWindowEvent>();
        for (String windowName : context.getWindowNames()) {
            PortletInfo info = context.getPortletInfo(windowName);
            if (info.getEventing() == null || !info.getEventing().getConsumedEvents().containsKey(event.getName())) continue;
            PortletWindowEvent distributedEvent = new PortletWindowEvent(event.getName(), event.getPayload(), windowName);
            windows.put(context.getWindow(windowName), distributedEvent);
        }
        return windows;
    }

    @Override
    public void setEventWiring(Map<Window, QName> sources, Map<Window, QName> destinations, String eventName) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull(sources, (String)"sources");
        ParameterValidation.throwIllegalArgExceptionIfNull(destinations, (String)"destinations");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)eventName, (String)"event name", null);
        if (sources.isEmpty()) {
            throw new IllegalArgumentException("empty sources map");
        }
        if (destinations.isEmpty()) {
            throw new IllegalArgumentException("empty destinations map");
        }
        Page parentPage = null;
        Set<Window> sw = sources.keySet();
        Set<Window> dw = destinations.keySet();
        HashSet<Window> all = new HashSet<Window>();
        all.addAll(sw);
        all.addAll(dw);
        for (Window window : all) {
            if (parentPage == null) {
                parentPage = window.getPage();
            }
            if (window.getPage().getId().equals(parentPage.getId())) continue;
            throw new IllegalCoordinationException("Parent page is not the same for all windows");
        }
        for (Window window : sw) {
            if (!dw.contains(window)) continue;
            throw new IllegalCoordinationException("The same window '" + window.getName() + "' cannot be source and destination of the same explicit wiring");
        }
        String prop_name = PREFIX_EVENT_NAME + eventName;
        String prop_wiring = PREFIX_EVENT_WIRING + eventName;
        for (Window window : sw) {
            window.setDeclaredProperty(prop_name, EVENT_ROLE_SOURCE);
            window.setDeclaredProperty(prop_wiring, sources.get(window).toString());
        }
        for (Window window : dw) {
            window.setDeclaredProperty(prop_name, EVENT_ROLE_DESTINATION);
            window.setDeclaredProperty(prop_wiring, destinations.get(window).toString());
        }
    }

    @Override
    public void removeEventWiring(EventWiringInfo info) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)info, (String)"EventWiringInfo");
        this.removeEventWiring(info.getPage(), info.getName());
    }

    @Override
    public void removeEventWiring(Page page, String wiringName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)wiringName, (String)"event wiring name");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        String prop_name = PREFIX_EVENT_NAME + wiringName;
        String prop_wiring = PREFIX_EVENT_WIRING + wiringName;
        for (PortalObject window : page.getChildren(8)) {
            window.setDeclaredProperty(prop_name, null);
            window.setDeclaredProperty(prop_wiring, null);
        }
    }

    @Override
    public void renameEventWiring(EventWiringInfo eventWiring, String newName) throws IllegalCoordinationException {
        this.removeEventWiring(eventWiring);
        this.setEventWiring(eventWiring.getSources(), eventWiring.getDestinations(), newName);
    }

    @Override
    public void renameEventWiring(Page page, String wiringName, String newName) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)wiringName, (String)"Event wiring name");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        EventWiringInfo info = this.getEventWiring(page, wiringName);
        this.removeEventWiring(page, wiringName);
        this.setEventWiring(info.getSources(), info.getDestinations(), newName);
    }

    @Override
    public void setEventWiringImplicitMode(PageContainer pageContainer, boolean mode) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)pageContainer, (String)"PageContainer");
        this.setImplicitMode(pageContainer, mode, EVENT_IMPLICIT_MODE);
    }

    @Override
    public void removeEventWiringImplicitMode(PageContainer pageContainer) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)pageContainer, (String)"PageContainer");
        this.setImplicitMode(pageContainer, null, EVENT_IMPLICIT_MODE);
    }

    @Override
    public Boolean isEventWiringImplicitModeEnabled(PageContainer pageContainer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)pageContainer, (String)"PageContainer");
        return this.decodeImplicitMode(pageContainer, EVENT_IMPLICIT_MODE);
    }

    @Override
    public Boolean resolveEventWiringImplicitModeEnabled(PageContainer page) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"PageContainer");
        return this.resolveImplicitMode(page, EVENT_IMPLICIT_MODE);
    }

    @Override
    public Collection<EventWiringInfo> getEventWirings(Page page, QName eventQName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)eventQName, (String)"event QName");
        Collection<EventWiringInfo> pageEvents = this.getEventWirings(page);
        HashSet<EventWiringInfo> events = new HashSet<EventWiringInfo>();
        for (EventWiringInfo event : pageEvents) {
            if (!event.getSources().containsValue(eventQName) && !event.getDestinations().containsValue(eventQName)) continue;
            pageEvents.add(event);
        }
        return events;
    }

    @Override
    public EventWiringInfo getEventWiring(Page page, String name) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"event wiring name");
        String wiringProp = PREFIX_EVENT_WIRING + name;
        String nameProp = PREFIX_EVENT_NAME + name;
        Collection<PortalObject> windows = page.getChildren(8);
        HashMap<Window, QName> sources = new HashMap<Window, QName>(windows.size());
        HashMap<Window, QName> destinations = new HashMap<Window, QName>(windows.size());
        for (PortalObject window : windows) {
            String eventName = window.getDeclaredProperty(wiringProp);
            if (eventName == null) continue;
            String role = window.getDeclaredProperty(nameProp);
            if (role == null) {
                throw new IllegalCoordinationException("Couldn't find role associated to event '" + name + "' in window " + window.getId());
            }
            QName qname = QName.valueOf(eventName);
            if (role.equalsIgnoreCase(EVENT_ROLE_SOURCE)) {
                sources.put((Window)window, qname);
                continue;
            }
            if (!role.equalsIgnoreCase(EVENT_ROLE_DESTINATION)) continue;
            destinations.put((Window)window, qname);
        }
        boolean emptySources = sources.isEmpty();
        boolean emptyDestinations = destinations.isEmpty();
        if (emptySources && emptyDestinations) {
            return null;
        }
        if (emptySources && !emptyDestinations || emptyDestinations) {
            throw new IllegalCoordinationException("Couldn't find sources or destinations for event '" + name + "'");
        }
        return new EventInfoPOJO(name, page, sources, destinations);
    }

    @Override
    public Collection<EventWiringInfo> getEventWirings(Page page) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        HashMap<String, EventInfoPOJO> events = new HashMap<String, EventInfoPOJO>();
        for (PortalObject window : page.getChildren(8)) {
            Set<String> propNames = window.getDeclaredProperties().keySet();
            for (String propName : propNames) {
                String prop_wiring;
                String name;
                EventInfoPOJO info;
                if (!propName.startsWith(PREFIX_EVENT_NAME)) continue;
                String en = propName.substring(PREFIX_EVENT_NAME_LENGTH);
                if (!events.keySet().contains(en)) {
                    info = new EventInfoPOJO(en, page);
                    events.put(en, info);
                } else {
                    info = (EventInfoPOJO)events.get(en);
                }
                if ((name = window.getDeclaredProperty(prop_wiring = PREFIX_EVENT_WIRING + en)) == null) continue;
                QName qname = QName.valueOf(name);
                String role = window.getDeclaredProperty(propName);
                if (role != null && role.equalsIgnoreCase(EVENT_ROLE_SOURCE)) {
                    info.getSources().put((Window)window, qname);
                    continue;
                }
                if (role == null || !role.equalsIgnoreCase(EVENT_ROLE_DESTINATION)) continue;
                info.getDestinations().put((Window)window, qname);
            }
        }
        HashSet<EventWiringInfo> immutableEvents = new HashSet<EventWiringInfo>();
        for (EventInfoPOJO info : events.values()) {
            immutableEvents.add(info.getImmutableWiringInfo());
        }
        return immutableEvents;
    }

    @Override
    public Collection<EventWiringInfo> getEventSourceWirings(Window window) {
        Collection<EventWiringInfo> pageEvents = this.getEventWirings(window.getPage());
        HashSet<EventWiringInfo> events = new HashSet<EventWiringInfo>();
        for (EventWiringInfo pageEvent : pageEvents) {
            if (!pageEvent.getSources().keySet().contains(window)) continue;
            events.add(pageEvent);
        }
        return events;
    }

    @Override
    public Collection<EventWiringInfo> getEventDestinationWirings(Window window) {
        Collection<EventWiringInfo> pageEvents = this.getEventWirings(window.getPage());
        HashSet<EventWiringInfo> events = new HashSet<EventWiringInfo>();
        for (EventWiringInfo pageEvent : pageEvents) {
            if (!pageEvent.getDestinations().keySet().contains(window)) continue;
            events.add(pageEvent);
        }
        return events;
    }

    @Override
    public void setParameterBinding(String name, Map<Window, Set<QName>> parameterMappings) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull(parameterMappings, (String)"parameter mappings");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)name, (String)"name", (String)"parameter binding");
        if (parameterMappings.isEmpty()) {
            throw new IllegalArgumentException("empty parameter mappings");
        }
        Page parentPage = null;
        for (Window window : parameterMappings.keySet()) {
            if (parentPage == null) {
                parentPage = window.getPage();
            }
            if (window.getPage().getId().equals(parentPage.getId())) continue;
            throw new IllegalCoordinationException("Parent page is not the same for all windows");
        }
        String prop_wiring = PREFIX_PARAMETER_BINDING + name;
        for (Window window : parameterMappings.keySet()) {
            window.setDeclaredProperty(prop_wiring, this.concatenateQNames(parameterMappings.get(window)));
        }
    }

    @Override
    public void removeParameterBinding(ParameterBindingInfo info) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)info, (String)"ParameterBindingInfo");
        this.removeParameterBinding(info.getPage(), info.getName());
    }

    @Override
    public void removeParameterBinding(Page page, String name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"parameter binding name");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        String nameProp = PREFIX_PARAMETER_BINDING + name;
        for (PortalObject window : page.getChildren(8)) {
            window.setDeclaredProperty(nameProp, null);
        }
    }

    @Override
    public void renameParameterBinding(ParameterBindingInfo parameterBinding, String newName) throws IllegalCoordinationException {
        this.removeParameterBinding(parameterBinding);
        this.setParameterBinding(newName, parameterBinding.getMappings());
    }

    @Override
    public void renameParameterBinding(Page page, String bindingName, String newName) throws IllegalCoordinationException {
        ParameterBindingInfo info = this.getParameterBinding(page, bindingName);
        this.removeParameterBinding(page, bindingName);
        this.setParameterBinding(newName, info.getMappings());
    }

    @Override
    public ParameterBindingInfo getParameterBinding(Page page, String name) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"parameter binding name");
        String nameProp = PREFIX_PARAMETER_BINDING + name;
        Collection<PortalObject> children = page.getChildren(8);
        HashMap<Window, Set<QName>> mappings = new HashMap<Window, Set<QName>>(children.size());
        for (PortalObject window : children) {
            String qNameList = window.getDeclaredProperty(nameProp);
            if (qNameList == null) continue;
            mappings.put((Window)window, this.extractQNames(qNameList));
        }
        if (mappings.isEmpty()) {
            return null;
        }
        return new ParameterInfoPOJO(name, page, mappings);
    }

    @Override
    public Boolean isParameterBindingImplicitModeEnabled(PageContainer pageContainer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)pageContainer, (String)"PageContainer");
        return this.decodeImplicitMode(pageContainer, PARAMETER_IMPLICIT_MODE);
    }

    @Override
    public void setParameterBindingImplicitMode(PageContainer pageContainer, boolean mode) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)pageContainer, (String)"PageContainer");
        this.setImplicitMode(pageContainer, mode, PARAMETER_IMPLICIT_MODE);
    }

    @Override
    public Boolean resolveParameterBindingImplicitModeEnabled(PageContainer pageContainer) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)pageContainer, (String)"PageContainer");
        return this.resolveImplicitMode(pageContainer, PARAMETER_IMPLICIT_MODE);
    }

    @Override
    public void removeParameterBindingImplicitMode(PageContainer pageContainer) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)pageContainer, (String)"PageContainer");
        this.setImplicitMode(pageContainer, null, PARAMETER_IMPLICIT_MODE);
    }

    @Override
    public void setAliasBinding(Page page, String aliasName, Set<QName> qnames) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)aliasName, (String)"name", (String)"alias binding");
        ParameterValidation.throwIllegalArgExceptionIfNull(qnames, (String)"aliased QNames");
        if (qnames.isEmpty()) {
            throw new IllegalArgumentException("Aliased QNames set is empty!");
        }
        String propName = PREFIX_PARAMETER_ALIAS_NAME + aliasName;
        page.setDeclaredProperty(propName, this.concatenateQNames(qnames));
    }

    private String concatenateQNames(Set<QName> qnames) throws IllegalCoordinationException {
        StringBuilder qnameList = new StringBuilder();
        Iterator<QName> i = qnames.iterator();
        while (i.hasNext()) {
            QName qname = i.next();
            if (qname.toString().contains(QNAME_SEPARATOR)) {
                throw new IllegalCoordinationException("Qname: " + qname + " contains forbidden character: " + QNAME_SEPARATOR);
            }
            qnameList.append(qname.toString());
            if (!i.hasNext()) continue;
            qnameList.append(QNAME_SEPARATOR);
        }
        return qnameList.toString();
    }

    @Override
    public void removeAliasBinding(AliasBindingInfo aliasInfo) throws IllegalCoordinationException {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)aliasInfo, (String)"AliasBindingInfo");
        this.removeAliasBinding(aliasInfo.getPage(), aliasInfo.getName());
    }

    @Override
    public void removeAliasBinding(Page page, String name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"alias binding name");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        String nameProp = PREFIX_PARAMETER_ALIAS_NAME + name;
        page.setDeclaredProperty(nameProp, null);
    }

    @Override
    public void renameAliasBinding(AliasBindingInfo aliasBinding, String newName) throws IllegalCoordinationException {
        this.removeAliasBinding(aliasBinding);
        this.setAliasBinding(aliasBinding.getPage(), newName, aliasBinding.getParameterNames());
    }

    @Override
    public void renameAliasBinding(Page page, String bindingName, String newName) throws IllegalCoordinationException {
        AliasBindingInfo info = this.getAliasBinding(page, bindingName);
        this.removeAliasBinding(page, bindingName);
        this.setAliasBinding(page, newName, info.getParameterNames());
    }

    public Collection<AliasBindingInfo> getAliasBindings(Page page) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        HashSet<AliasBindingInfo> aliases = new HashSet<AliasBindingInfo>();
        for (String propertyName : page.getDeclaredProperties().keySet()) {
            if (!propertyName.startsWith(PREFIX_PARAMETER_ALIAS_NAME)) continue;
            String aliasName = propertyName.substring(PREFIX_PARAMETER_ALIAS_LENGTH);
            AliasInfoPOJO info = new AliasInfoPOJO(aliasName, page);
            String qnameList = page.getDeclaredProperty(propertyName);
            String[] qnames = qnameList.split(QNAME_SEPARATOR);
            if (qnames != null) {
                for (String string : qnames) {
                    QName qname = QName.valueOf(string);
                    info.add(qname);
                }
            }
            aliases.add(info);
        }
        return aliases;
    }

    @Override
    public AliasBindingInfo getAliasBinding(Page page, String name) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)name, (String)"alias binding name");
        String nameProp = PREFIX_PARAMETER_ALIAS_NAME + name;
        String qNameList = page.getDeclaredProperty(nameProp);
        if (qNameList != null) {
            Set<QName> names = this.extractQNames(qNameList);
            return new AliasInfoPOJO(name, page, names);
        }
        return null;
    }

    private Set<QName> extractQNames(String qNameList) {
        String[] qnames = qNameList.split(QNAME_SEPARATOR);
        HashSet<QName> names = new HashSet<QName>(qnames.length);
        for (String string : qnames) {
            QName qname = QName.valueOf(string);
            names.add(qname);
        }
        return names;
    }

    @Override
    public Collection<? extends ParameterBindingInfo> getParameterBindings(Page page, QName parameterName) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)parameterName, (String)"parameter QName");
        Collection<? extends ParameterBindingInfo> pageParams = this.getParameterBindings(page);
        HashSet<ParameterBindingInfo> infos = new HashSet<ParameterBindingInfo>();
        for (ParameterBindingInfo parameterBindingInfo : pageParams) {
            Collection<Set<QName>> allQNames = parameterBindingInfo.getMappings().values();
            for (Set<QName> qNameSet : allQNames) {
                if (!qNameSet.contains(parameterName)) continue;
                infos.add(parameterBindingInfo);
            }
        }
        return infos;
    }

    public Collection<ParameterBindingInfo> getParameterBindings(Window window) {
        Collection<? extends ParameterBindingInfo> pageParams = this.getParameterBindings(window.getPage());
        HashSet<ParameterBindingInfo> infos = new HashSet<ParameterBindingInfo>();
        for (ParameterBindingInfo parameterBindingInfo : pageParams) {
            if (!parameterBindingInfo.getMappings().keySet().contains(window)) continue;
            infos.add(parameterBindingInfo);
        }
        return infos;
    }

    @Override
    public Collection<? extends ParameterBindingInfo> getParameterBindings(Page page) {
        ParameterValidation.throwIllegalArgExceptionIfNull((Object)page, (String)"Page");
        Collection<PortalObject> children = page.getChildren(8);
        HashMap<String, ParameterInfoPOJO> params = new HashMap<String, ParameterInfoPOJO>();
        for (PortalObject child : children) {
            Set<String> propNames = child.getProperties().keySet();
            for (String propName : propNames) {
                QName qname;
                String binding;
                ParameterInfoPOJO info;
                if (!propName.startsWith(PREFIX_PARAMETER_BINDING)) continue;
                String pn = propName.substring(PREFIX_PARAMETER_BINDING_LENGTH);
                if (!params.keySet().contains(pn)) {
                    info = new ParameterInfoPOJO(pn, page);
                    params.put(pn, info);
                } else {
                    info = (ParameterInfoPOJO)params.get(pn);
                }
                if ((binding = child.getProperty(propName)) == null || (qname = QName.valueOf(binding)) == null) continue;
                info.addMapping((Window)child, qname);
            }
        }
        return Collections.unmodifiableCollection(params.values());
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public EventConverter getEventConverter() {
        return this.eventConverter;
    }

    public void setEventConverter(EventConverter eventConverter) {
        this.eventConverter = eventConverter;
    }

    private void setImplicitMode(PageContainer pageContainer, Boolean mode, String prefix) {
        if (mode == null) {
            pageContainer.setDeclaredProperty(prefix, null);
        } else {
            pageContainer.setDeclaredProperty(prefix, mode.toString());
        }
    }

    private Boolean decodeImplicitMode(PageContainer pageContainer, String prefix) {
        String value = pageContainer.getDeclaredProperty(prefix);
        return value != null ? Boolean.valueOf(value) : null;
    }

    private Boolean resolveImplicitMode(PageContainer pageContainer, String prefix) {
        String value = pageContainer.getDeclaredProperty(prefix);
        Boolean mode = value == null ? this.resolveRecursiveImplicitMode(pageContainer, prefix) : Boolean.valueOf(value);
        if (mode != null) {
            return mode;
        }
        return DEFAULT_IMPLICIT_MODE;
    }

    private Boolean resolveRecursiveImplicitMode(PortalObject po, String prefix) {
        String value = po.getDeclaredProperty(prefix);
        Boolean mode = null;
        if (value != null) {
            mode = Boolean.valueOf(value);
        }
        if (mode != null) {
            return mode;
        }
        if (!(po instanceof Portal)) {
            return this.resolveRecursiveImplicitMode(po.getParent(), prefix);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AliasInfoPOJO
    implements AliasBindingInfo {
        private final String name;
        private final Page page;
        private final Set<QName> names;

        private AliasInfoPOJO(String name, Page page, Set<QName> names) {
            this.name = name;
            this.page = page;
            this.names = names;
        }

        private AliasInfoPOJO(String name, Page page) {
            this(name, page, new HashSet<QName>());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<QName> getParameterNames() {
            return Collections.unmodifiableSet(this.names);
        }

        @Override
        public Page getPage() {
            return this.page;
        }

        private void add(QName qname) {
            this.names.add(qname);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParameterInfoPOJO
    implements ParameterBindingInfo {
        private final String name;
        private Map<Window, Set<QName>> mappings;
        private final Page page;

        private ParameterInfoPOJO(String name, Page page, Map<Window, Set<QName>> mappings) {
            this.name = name;
            this.mappings = mappings;
            this.page = page;
        }

        private ParameterInfoPOJO(String name, Page page) {
            this(name, page, new HashMap<Window, Set<QName>>());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<Window, Set<QName>> getMappings() {
            return Collections.unmodifiableMap(this.mappings);
        }

        @Override
        public Page getPage() {
            return this.page;
        }

        private void addMapping(Window window, QName qname) {
            this.mappings = Utils.addToMultiMap(this.mappings, window, qname);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventInfoPOJO
    implements EventWiringInfo {
        private final String name;
        private final Map<Window, QName> sources;
        private final Map<Window, QName> destinations;
        private final Page page;

        private EventInfoPOJO(String name, Page page, Map<Window, QName> sources, Map<Window, QName> destinations) {
            this.name = name;
            this.sources = sources;
            this.destinations = destinations;
            this.page = page;
        }

        private EventInfoPOJO(String name, Page page) {
            this(name, page, new HashMap<Window, QName>(), new HashMap<Window, QName>());
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Map<Window, QName> getSources() {
            return this.sources;
        }

        @Override
        public Map<Window, QName> getDestinations() {
            return this.destinations;
        }

        EventWiringInfo getImmutableWiringInfo() {
            return new EventInfoPOJO(this.name, this.page, Collections.unmodifiableMap(this.sources), Collections.unmodifiableMap(this.destinations));
        }

        @Override
        public Page getPage() {
            return this.page;
        }
    }
}

