/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.domain;

import fr.toutatice.portail.cms.nuxeo.api.Customizable;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.IMenubarModule;
import fr.toutatice.portail.cms.nuxeo.api.domain.INavigationAdapterModule;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.player.IPlayerModule;
import org.osivia.portal.api.portlet.PortalGenericPortlet;
import org.osivia.portal.api.theming.TabGroup;
import org.osivia.portal.core.cms.DomainContextualization;

public abstract class AbstractPluginPortlet
extends PortalGenericPortlet
implements ICustomizationModule {
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    public static final int DEFAULT_DEPLOYMENT_ORDER = 100;
    private CustomizationModuleMetadatas metadatas;
    private ICustomizationModulesRepository repository;
    private final ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();

    public int getOrder() {
        return 100;
    }

    public void init() throws PortletException {
        super.init();
        this.metadatas = new CustomizationModuleMetadatas();
        this.metadatas.setName(this.getPluginName());
        this.metadatas.setModule((ICustomizationModule)this);
        this.metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.cms.id"));
        this.metadatas.setOrder(this.getOrder());
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    protected abstract String getPluginName();

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void parseJavaServerPages(String directoryPath, File directory, Map<String, CustomizedJsp> customizedPages) {
        File[] children;
        for (File child : children = directory.listFiles()) {
            if (child.isFile()) {
                String absolutePath = child.getAbsolutePath();
                String relativePath = StringUtils.removeStart((String)absolutePath, (String)directoryPath);
                CustomizedJsp customizedPage = new CustomizedJsp(absolutePath, this.classLoader);
                customizedPages.put(relativePath, customizedPage);
            }
            if (!child.isDirectory()) continue;
            this.parseJavaServerPages(directoryPath, child, customizedPages);
        }
    }

    public void customize(String customizationID, CustomizationContext context) {
        String directoryPath;
        File directory;
        Map attributes = context.getAttributes();
        this.customizeCMSProperties(customizationID, context);
        ConcurrentHashMap<String, CustomizedJsp> customizedPages = (ConcurrentHashMap<String, CustomizedJsp>)attributes.get(Customizable.JSP.toString());
        if (customizedPages == null) {
            customizedPages = new ConcurrentHashMap<String, CustomizedJsp>();
            attributes.put(Customizable.JSP.toString(), customizedPages);
        }
        if ((directory = new File(directoryPath = this.getPortletContext().getRealPath("/WEB-INF/custom/jsp"))).exists()) {
            this.parseJavaServerPages(directoryPath, directory, customizedPages);
        }
    }

    protected abstract void customizeCMSProperties(String var1, CustomizationContext var2);

    protected List<IPlayerModule> getPlayers(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList players = (ArrayList)attributes.get(Customizable.PLAYER.toString());
        if (players == null) {
            players = new ArrayList();
            attributes.put(Customizable.PLAYER.toString(), players);
        }
        return players;
    }

    protected Map<String, ListTemplate> getListTemplates(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap templates = (ConcurrentHashMap)attributes.get(Customizable.LIST_TEMPLATE.toString() + context.getLocale());
        if (templates == null) {
            templates = new ConcurrentHashMap();
            attributes.put(Customizable.LIST_TEMPLATE.toString() + context.getLocale(), templates);
        }
        return templates;
    }

    protected Map<String, DocumentType> getDocTypes(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap docTypes = (ConcurrentHashMap)attributes.get(Customizable.DOC_TYPE.toString());
        if (docTypes == null) {
            docTypes = new ConcurrentHashMap();
            attributes.put(Customizable.DOC_TYPE.toString(), docTypes);
        }
        return docTypes;
    }

    protected void addSubType(CustomizationContext context, String parentDocTypeName, String childDocTypeName) {
        Map<String, DocumentType> docTypes = this.getDocTypes(context);
        DocumentType parentDocType = docTypes.get(parentDocTypeName);
        if (parentDocType != null) {
            parentDocType.getPortalFormSubTypes().add(childDocTypeName);
        }
    }

    protected List<FragmentType> getFragmentTypes(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList fragmentTypes = (ArrayList)attributes.get(Customizable.FRAGMENT.toString() + context.getLocale());
        if (fragmentTypes == null) {
            fragmentTypes = new ArrayList();
            attributes.put(Customizable.FRAGMENT.toString() + context.getLocale(), fragmentTypes);
        }
        return fragmentTypes;
    }

    protected Map<String, EditableWindow> getEditableWindows(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap ew = (ConcurrentHashMap)attributes.get(Customizable.EDITABLE_WINDOW.toString() + context.getLocale());
        if (ew == null) {
            ew = new ConcurrentHashMap();
            attributes.put(Customizable.EDITABLE_WINDOW.toString() + context.getLocale(), ew);
        }
        return ew;
    }

    protected List<IMenubarModule> getMenubars(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList menubars = (ArrayList)attributes.get(Customizable.MENUBAR.toString());
        if (menubars == null) {
            menubars = new ArrayList();
            attributes.put(Customizable.MENUBAR.toString(), menubars);
        }
        return menubars;
    }

    protected SortedMap<String, String> getMenuTemplates(CustomizationContext context) {
        Map attributes = context.getAttributes();
        TreeMap templates = (TreeMap)attributes.get(Customizable.MENU_TEMPLATE.toString() + context.getLocale());
        if (templates == null) {
            templates = new TreeMap();
            attributes.put(Customizable.MENU_TEMPLATE.toString() + context.getLocale(), templates);
        }
        return templates;
    }

    protected List<INavigationAdapterModule> getNavigationAdapters(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList adapters = (ArrayList)attributes.get(Customizable.NAVIGATION_ADAPTERS.toString());
        if (adapters == null) {
            adapters = new ArrayList();
            attributes.put(Customizable.NAVIGATION_ADAPTERS.toString(), adapters);
        }
        return adapters;
    }

    protected List<DomainContextualization> getDomainContextualizations(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ArrayList contextualizations = (ArrayList)attributes.get(Customizable.DOMAIN_CONTEXTUALIZATION.toString());
        if (contextualizations == null) {
            contextualizations = new ArrayList();
            attributes.put(Customizable.DOMAIN_CONTEXTUALIZATION.toString(), contextualizations);
        }
        return contextualizations;
    }

    protected Map<String, TabGroup> getTabGroups(CustomizationContext context) {
        Map attributes = context.getAttributes();
        ConcurrentHashMap tabGroups = (ConcurrentHashMap)attributes.get(Customizable.TAB_GROUPS.toString());
        if (tabGroups == null) {
            tabGroups = new ConcurrentHashMap();
            attributes.put(Customizable.TAB_GROUPS.toString(), tabGroups);
        }
        return tabGroups;
    }
}

