/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.DataProcessor;
import org.jrobin.graph.Area;
import org.jrobin.graph.CommentText;
import org.jrobin.graph.HRule;
import org.jrobin.graph.ImageParameters;
import org.jrobin.graph.ImageWorker;
import org.jrobin.graph.LegendComposer;
import org.jrobin.graph.LegendText;
import org.jrobin.graph.Line;
import org.jrobin.graph.Mapper;
import org.jrobin.graph.PlotElement;
import org.jrobin.graph.PrintText;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphInfo;
import org.jrobin.graph.Rule;
import org.jrobin.graph.Source;
import org.jrobin.graph.SourcedPlotElement;
import org.jrobin.graph.Stack;
import org.jrobin.graph.TimeAxis;
import org.jrobin.graph.VRule;
import org.jrobin.graph.ValueAxis;
import org.jrobin.graph.ValueAxisLogarithmic;
import org.jrobin.graph.ValueAxisMrtg;
import org.jrobin.graph.ValueScaler;

public class RrdGraph
implements RrdGraphConstants {
    RrdGraphDef gdef;
    ImageParameters im = new ImageParameters();
    DataProcessor dproc;
    ImageWorker worker;
    Mapper mapper;
    RrdGraphInfo info = new RrdGraphInfo();
    private String signature;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RrdGraph(RrdGraphDef rrdGraphDef) throws IOException, RrdException {
        this.gdef = rrdGraphDef;
        this.signature = rrdGraphDef.getSignature();
        this.worker = new ImageWorker(100, 100);
        try {
            this.createGraph();
        }
        finally {
            this.worker.dispose();
            this.worker = null;
            this.dproc = null;
        }
    }

    public RrdGraphInfo getRrdGraphInfo() {
        return this.info;
    }

    private void createGraph() throws RrdException, IOException {
        boolean bl = this.lazyCheck();
        if (!bl || this.gdef.printStatementCount() != 0) {
            this.fetchData();
            this.resolveTextElements();
            if (this.gdef.shouldPlot() && !bl) {
                this.calculatePlotValues();
                this.findMinMaxValues();
                this.identifySiUnit();
                this.expandValueRange();
                this.removeOutOfRangeRules();
                this.initializeLimits();
                this.placeLegends();
                this.createImageWorker();
                this.drawBackground();
                this.drawData();
                this.drawGrid();
                this.drawAxis();
                this.drawText();
                this.drawLegend();
                this.drawRules();
                this.gator();
                this.drawOverlay();
                this.saveImage();
            }
        }
        this.collectInfo();
    }

    private void collectInfo() {
        this.info.filename = this.gdef.filename;
        this.info.width = this.im.xgif;
        this.info.height = this.im.ygif;
        for (CommentText commentText : this.gdef.comments) {
            PrintText printText;
            if (!(commentText instanceof PrintText) || !(printText = (PrintText)commentText).isPrint()) continue;
            this.info.addPrintLine(printText.resolvedText);
        }
        if (this.gdef.imageInfo != null) {
            this.info.imgInfo = Util.sprintf(this.gdef.imageInfo, this.gdef.filename, this.im.xgif, this.im.ygif);
        }
    }

    private void saveImage() throws IOException {
        this.info.bytes = !this.gdef.filename.equals("-") ? this.worker.saveImage(this.gdef.filename, this.gdef.imageFormat, this.gdef.imageQuality) : this.worker.getImageBytes(this.gdef.imageFormat, this.gdef.imageQuality);
    }

    private void drawOverlay() throws IOException {
        if (this.gdef.overlayImage != null) {
            this.worker.loadImage(this.gdef.overlayImage);
        }
    }

    private void gator() {
        if (!this.gdef.onlyGraph && this.gdef.showSignature) {
            Font font = this.gdef.getSmallFont().deriveFont(0, 9.0f);
            int n = (int)((double)(this.im.xgif - 2) - this.worker.getFontAscent(font));
            int n2 = 4;
            this.worker.transform(n, n2, 1.5707963267948966);
            this.worker.drawString(this.signature, 0, 0, font, Color.LIGHT_GRAY);
            this.worker.reset();
        }
    }

    private void drawRules() {
        this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
        for (PlotElement plotElement : this.gdef.plotElements) {
            int n;
            Rule rule;
            if (plotElement instanceof HRule) {
                rule = (HRule)plotElement;
                if (!(rule.value >= this.im.minval) || !(rule.value <= this.im.maxval)) continue;
                n = this.mapper.ytr(rule.value);
                this.worker.drawLine(this.im.xorigin, n, this.im.xorigin + this.im.xsize, n, rule.color, new BasicStroke(rule.width));
                continue;
            }
            if (!(plotElement instanceof VRule)) continue;
            rule = (VRule)plotElement;
            if (((VRule)rule).timestamp < this.im.start || ((VRule)rule).timestamp > this.im.end) continue;
            n = this.mapper.xtr(((VRule)rule).timestamp);
            this.worker.drawLine(n, this.im.yorigin, n, this.im.yorigin - this.im.ysize, ((VRule)rule).color, new BasicStroke(((VRule)rule).width));
        }
        this.worker.reset();
    }

    private void drawText() {
        if (!this.gdef.onlyGraph) {
            int n;
            int n2;
            if (this.gdef.title != null) {
                n2 = this.im.xgif / 2 - (int)(this.worker.getStringWidth(this.gdef.title, this.gdef.largeFont) / 2.0);
                n = 12 + (int)this.worker.getFontAscent(this.gdef.largeFont);
                this.worker.drawString(this.gdef.title, n2, n, this.gdef.largeFont, this.gdef.colors[6]);
            }
            if (this.gdef.verticalLabel != null) {
                n2 = 10;
                n = this.im.yorigin - this.im.ysize / 2 + (int)this.worker.getStringWidth(this.gdef.verticalLabel, this.gdef.getSmallFont()) / 2;
                int n3 = (int)this.worker.getFontAscent(this.gdef.smallFont);
                this.worker.transform(n2, n, -1.5707963267948966);
                this.worker.drawString(this.gdef.verticalLabel, 0, n3, this.gdef.smallFont, this.gdef.colors[6]);
                this.worker.reset();
            }
        }
    }

    private void drawGrid() {
        if (!this.gdef.onlyGraph) {
            boolean bl;
            Paint paint = this.gdef.colors[2];
            Paint paint2 = this.gdef.colors[3];
            BasicStroke basicStroke = new BasicStroke(1.0f);
            this.worker.drawLine(0, 0, this.im.xgif - 1, 0, paint, basicStroke);
            this.worker.drawLine(1, 1, this.im.xgif - 2, 1, paint, basicStroke);
            this.worker.drawLine(0, 0, 0, this.im.ygif - 1, paint, basicStroke);
            this.worker.drawLine(1, 1, 1, this.im.ygif - 2, paint, basicStroke);
            this.worker.drawLine(this.im.xgif - 1, 0, this.im.xgif - 1, this.im.ygif - 1, paint2, basicStroke);
            this.worker.drawLine(0, this.im.ygif - 1, this.im.xgif - 1, this.im.ygif - 1, paint2, basicStroke);
            this.worker.drawLine(this.im.xgif - 2, 1, this.im.xgif - 2, this.im.ygif - 2, paint2, basicStroke);
            this.worker.drawLine(1, this.im.ygif - 2, this.im.xgif - 2, this.im.ygif - 2, paint2, basicStroke);
            if (this.gdef.drawXGrid) {
                new TimeAxis(this).draw();
            }
            if (this.gdef.drawYGrid && !(bl = this.gdef.altYMrtg ? new ValueAxisMrtg(this).draw() : (this.gdef.logarithmic ? new ValueAxisLogarithmic(this).draw() : new ValueAxis(this).draw()))) {
                String string = "No Data Found";
                this.worker.drawString(string, this.im.xgif / 2 - (int)this.worker.getStringWidth(string, this.gdef.largeFont) / 2, (2 * this.im.yorigin - this.im.ysize) / 2, this.gdef.largeFont, this.gdef.colors[6]);
            }
        }
    }

    private void drawData() throws RrdException {
        this.worker.setAntiAliasing(this.gdef.antiAliasing);
        this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
        double d = this.mapper.ytr(this.im.minval > 0.0 ? this.im.minval : (this.im.maxval < 0.0 ? this.im.maxval : 0.0));
        double[] dArray = this.xtr(this.dproc.getTimestamps());
        double[] dArray2 = null;
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            SourcedPlotElement sourcedPlotElement = (SourcedPlotElement)plotElement;
            double[] dArray3 = this.ytr(sourcedPlotElement.getValues());
            if (sourcedPlotElement instanceof Line) {
                this.worker.drawPolyline(dArray, dArray3, sourcedPlotElement.color, (Stroke)new BasicStroke(((Line)sourcedPlotElement).width));
            } else if (sourcedPlotElement instanceof Area) {
                this.worker.fillPolygon(dArray, d, dArray3, sourcedPlotElement.color);
            } else if (sourcedPlotElement instanceof Stack) {
                Stack stack = (Stack)sourcedPlotElement;
                float f = stack.getParentLineWidth();
                if (f >= 0.0f) {
                    this.worker.drawPolyline(dArray, dArray3, stack.color, (Stroke)new BasicStroke(f));
                } else {
                    this.worker.fillPolygon(dArray, dArray2, dArray3, stack.color);
                    this.worker.drawPolyline(dArray, dArray2, stack.getParentColor(), (Stroke)new BasicStroke(0.0f));
                }
            } else {
                throw new RrdException("Unknown plot source: " + sourcedPlotElement.getClass().getName());
            }
            dArray2 = dArray3;
        }
        this.worker.reset();
        this.worker.setAntiAliasing(false);
    }

    private void drawAxis() {
        if (!this.gdef.onlyGraph) {
            Paint paint = this.gdef.colors[4];
            Paint paint2 = this.gdef.colors[6];
            Paint paint3 = this.gdef.colors[8];
            BasicStroke basicStroke = new BasicStroke(1.0f);
            this.worker.drawLine(this.im.xorigin + this.im.xsize, this.im.yorigin, this.im.xorigin + this.im.xsize, this.im.yorigin - this.im.ysize, paint, basicStroke);
            this.worker.drawLine(this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xorigin + this.im.xsize, this.im.yorigin - this.im.ysize, paint, basicStroke);
            this.worker.drawLine(this.im.xorigin - 4, this.im.yorigin, this.im.xorigin + this.im.xsize + 4, this.im.yorigin, paint2, basicStroke);
            this.worker.drawLine(this.im.xorigin, this.im.yorigin, this.im.xorigin, this.im.yorigin - this.im.ysize, paint, basicStroke);
            this.worker.drawLine(this.im.xorigin + this.im.xsize + 4, this.im.yorigin - 3, this.im.xorigin + this.im.xsize + 4, this.im.yorigin + 3, paint3, basicStroke);
            this.worker.drawLine(this.im.xorigin + this.im.xsize + 4, this.im.yorigin - 3, this.im.xorigin + this.im.xsize + 9, this.im.yorigin, paint3, basicStroke);
            this.worker.drawLine(this.im.xorigin + this.im.xsize + 4, this.im.yorigin + 3, this.im.xorigin + this.im.xsize + 9, this.im.yorigin, paint3, basicStroke);
        }
    }

    private void drawBackground() throws IOException {
        this.worker.fillRect(0, 0, this.im.xgif, this.im.ygif, this.gdef.colors[1]);
        if (this.gdef.backgroundImage != null) {
            this.worker.loadImage(this.gdef.backgroundImage);
        }
        this.worker.fillRect(this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xsize, this.im.ysize, this.gdef.colors[0]);
    }

    private void createImageWorker() {
        this.worker.resize(this.im.xgif, this.im.ygif);
    }

    private void placeLegends() {
        if (!this.gdef.noLegend && !this.gdef.onlyGraph) {
            int n = (int)(this.getSmallFontCharWidth() * 2.0);
            LegendComposer legendComposer = new LegendComposer(this, n, this.im.ygif, this.im.xgif - 2 * n);
            this.im.ygif = legendComposer.placeComments() + 6;
        }
    }

    private void initializeLimits() throws RrdException {
        this.im.xsize = this.gdef.width;
        this.im.ysize = this.gdef.height;
        this.im.unitslength = this.gdef.unitsLength;
        if (this.gdef.onlyGraph) {
            if (this.im.ysize > 64) {
                throw new RrdException("Cannot create graph only, height too big");
            }
            this.im.xorigin = 0;
        } else {
            this.im.xorigin = (int)(10.0 + (double)this.im.unitslength * this.getSmallFontCharWidth());
        }
        if (this.gdef.verticalLabel != null) {
            this.im.xorigin = (int)((double)this.im.xorigin + this.getSmallFontHeight());
        }
        this.im.yorigin = this.gdef.onlyGraph ? this.im.ysize : 12 + this.im.ysize;
        this.mapper = new Mapper(this);
        if (this.gdef.title != null) {
            this.im.yorigin = (int)((double)this.im.yorigin + (this.getLargeFontHeight() + 6.0));
        }
        if (this.gdef.onlyGraph) {
            this.im.xgif = this.im.xsize;
            this.im.ygif = this.im.yorigin;
        } else {
            this.im.xgif = 16 + this.im.xsize + this.im.xorigin;
            this.im.ygif = this.im.yorigin + (int)(2.0 * this.getSmallFontHeight());
        }
    }

    private void removeOutOfRangeRules() {
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (plotElement instanceof HRule) {
                ((HRule)plotElement).setLegendVisibility(this.im.minval, this.im.maxval, this.gdef.forceRulesLegend);
                continue;
            }
            if (!(plotElement instanceof VRule)) continue;
            ((VRule)plotElement).setLegendVisibility(this.im.start, this.im.end, this.gdef.forceRulesLegend);
        }
    }

    private void expandValueRange() {
        this.im.ygridstep = this.gdef.valueAxisSetting != null ? this.gdef.valueAxisSetting.gridStep : Double.NaN;
        int n = this.im.ylabfact = this.gdef.valueAxisSetting != null ? this.gdef.valueAxisSetting.labelFactor : 0;
        if (!this.gdef.rigid && !this.gdef.logarithmic) {
            double[] dArray = new double[]{1000.0, 900.0, 800.0, 750.0, 700.0, 600.0, 500.0, 400.0, 300.0, 250.0, 200.0, 125.0, 100.0, 90.0, 80.0, 75.0, 70.0, 60.0, 50.0, 40.0, 30.0, 25.0, 20.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.5, 3.0, 2.5, 2.0, 1.8, 1.5, 1.2, 1.0, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.0, -1.0};
            if (Double.isNaN(this.im.ygridstep)) {
                if (this.gdef.altYMrtg) {
                    double d;
                    double d2;
                    this.im.decimals = Math.ceil(Math.log10(Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))));
                    this.im.quadrant = 0;
                    if (this.im.minval < 0.0) {
                        this.im.quadrant = 2;
                        if (this.im.maxval <= 0.0) {
                            this.im.quadrant = 4;
                        }
                    }
                    switch (this.im.quadrant) {
                        case 2: {
                            this.im.scaledstep = Math.ceil(50.0 * Math.pow(10.0, -this.im.decimals) * Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))) * Math.pow(10.0, this.im.decimals - 2.0);
                            d2 = -2.0 * this.im.scaledstep;
                            d = 2.0 * this.im.scaledstep;
                            break;
                        }
                        case 4: {
                            this.im.scaledstep = Math.ceil(25.0 * Math.pow(10.0, -this.im.decimals) * Math.abs(this.im.minval)) * Math.pow(10.0, this.im.decimals - 2.0);
                            d2 = -4.0 * this.im.scaledstep;
                            d = 0.0;
                            break;
                        }
                        default: {
                            this.im.scaledstep = Math.ceil(25.0 * Math.pow(10.0, -this.im.decimals) * this.im.maxval) * Math.pow(10.0, this.im.decimals - 2.0);
                            d2 = 0.0;
                            d = 4.0 * this.im.scaledstep;
                        }
                    }
                    this.im.minval = d2;
                    this.im.maxval = d;
                } else if (this.gdef.altAutoscale) {
                    double d = this.im.maxval - this.im.minval;
                    double d3 = d * 0.1;
                    double d4 = 2.0 * Math.pow(10.0, Math.floor(Math.log10(Math.max(Math.abs(this.im.minval), Math.abs(this.im.maxval)))) - 2.0);
                    if (d < d4) {
                        d3 = (d4 - d) * 0.55;
                    }
                    this.im.minval -= d3;
                    this.im.maxval += d3;
                } else if (this.gdef.altAutoscaleMax) {
                    double d = (this.im.maxval - this.im.minval) * 0.1;
                    this.im.maxval += d;
                } else {
                    double d = this.im.minval / this.im.magfact;
                    double d5 = this.im.maxval / this.im.magfact;
                    int n2 = 1;
                    while (dArray[n2] > 0.0) {
                        if (dArray[n2 - 1] >= d && dArray[n2] <= d) {
                            this.im.minval = dArray[n2] * this.im.magfact;
                        }
                        if (-dArray[n2 - 1] <= d && -dArray[n2] >= d) {
                            this.im.minval = -dArray[n2 - 1] * this.im.magfact;
                        }
                        if (dArray[n2 - 1] >= d5 && dArray[n2] <= d5) {
                            this.im.maxval = dArray[n2 - 1] * this.im.magfact;
                        }
                        if (-dArray[n2 - 1] <= d5 && -dArray[n2] >= d5) {
                            this.im.maxval = -dArray[n2] * this.im.magfact;
                        }
                        ++n2;
                    }
                }
            } else {
                this.im.minval = (double)this.im.ylabfact * this.im.ygridstep * Math.floor(this.im.minval / ((double)this.im.ylabfact * this.im.ygridstep));
                this.im.maxval = (double)this.im.ylabfact * this.im.ygridstep * Math.ceil(this.im.maxval / ((double)this.im.ylabfact * this.im.ygridstep));
            }
        }
    }

    private void identifySiUnit() {
        this.im.unitsexponent = this.gdef.unitsExponent;
        this.im.base = this.gdef.base;
        if (!this.gdef.logarithmic) {
            char[] cArray = new char[]{'a', 'f', 'p', 'n', 'u', 'm', ' ', 'k', 'M', 'G', 'T', 'P', 'E'};
            int n = 6;
            double d = this.im.unitsexponent != Integer.MAX_VALUE ? Math.floor(this.im.unitsexponent / 3) : Math.floor(Math.log(Math.max(Math.abs(this.im.minval), Math.abs(this.im.maxval))) / Math.log(this.im.base));
            this.im.magfact = Math.pow(this.im.base, d);
            this.im.symbol = d + (double)n < (double)cArray.length && d + (double)n >= 0.0 ? cArray[(int)d + n] : (char)63;
        }
    }

    private void findMinMaxValues() {
        double d = Double.NaN;
        double d2 = Double.NaN;
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            d = Util.min(((SourcedPlotElement)plotElement).getMinValue(), d);
            d2 = Util.max(((SourcedPlotElement)plotElement).getMaxValue(), d2);
        }
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        if (Double.isNaN(d2)) {
            d2 = 1.0;
        }
        this.im.minval = this.gdef.minValue;
        this.im.maxval = this.gdef.maxValue;
        if (Double.isNaN(this.im.minval) || !this.gdef.logarithmic && !this.gdef.rigid && this.im.minval > d) {
            this.im.minval = d;
        }
        if (Double.isNaN(this.im.maxval) || !this.gdef.rigid && this.im.maxval < d2) {
            this.im.maxval = this.gdef.logarithmic ? d2 * 1.1 : d2;
        }
        if (this.im.minval > this.im.maxval) {
            this.im.minval = 0.99 * this.im.maxval;
        }
        if (this.im.minval == this.im.maxval) {
            this.im.maxval *= 1.01;
            if (!this.gdef.logarithmic) {
                this.im.minval *= 0.99;
            }
            if (this.im.maxval == 0.0) {
                this.im.maxval = 1.0;
            }
        }
    }

    private void calculatePlotValues() throws RrdException {
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            ((SourcedPlotElement)plotElement).assignValues(this.dproc);
        }
    }

    private void resolveTextElements() throws RrdException {
        ValueScaler valueScaler = new ValueScaler(this.gdef.base);
        for (CommentText commentText : this.gdef.comments) {
            commentText.resolveText(this.dproc, valueScaler);
        }
    }

    private void fetchData() throws RrdException, IOException {
        this.dproc = new DataProcessor(this.gdef.startTime, this.gdef.endTime);
        this.dproc.setPoolUsed(this.gdef.poolUsed);
        if (this.gdef.step > 0L) {
            this.dproc.setStep(this.gdef.step);
        }
        for (Source source : this.gdef.sources) {
            source.requestData(this.dproc);
        }
        this.dproc.processData();
        this.im.start = this.gdef.startTime;
        this.im.end = this.gdef.endTime;
    }

    private boolean lazyCheck() {
        if (!this.gdef.lazy || !Util.fileExists(this.gdef.filename)) {
            return false;
        }
        long l = (this.gdef.endTime - this.gdef.startTime) / (long)this.gdef.width;
        long l2 = Util.getTimestamp() - Util.getLastModified(this.gdef.filename);
        return l2 <= l;
    }

    private void drawLegend() {
        if (!this.gdef.onlyGraph && !this.gdef.noLegend) {
            int n = (int)this.worker.getFontAscent(this.gdef.smallFont);
            int n2 = (int)this.getBox();
            int n3 = (int)this.getBoxSpace();
            for (CommentText commentText : this.gdef.comments) {
                if (!commentText.isValidGraphElement()) continue;
                int n4 = commentText.x;
                int n5 = commentText.y + n;
                if (commentText instanceof LegendText) {
                    this.worker.fillRect(n4, n5 - n2, n2, n2, this.gdef.colors[7]);
                    this.worker.fillRect(n4 + 1, n5 - n2 + 1, n2 - 2, n2 - 2, ((LegendText)commentText).legendColor);
                    this.worker.drawString(commentText.resolvedText, n4 + n3, n5, this.gdef.smallFont, this.gdef.colors[6]);
                    continue;
                }
                this.worker.drawString(commentText.resolvedText, n4, n5, this.gdef.smallFont, this.gdef.colors[6]);
            }
        }
    }

    double getSmallFontHeight() {
        return this.worker.getFontHeight(this.gdef.smallFont);
    }

    private double getLargeFontHeight() {
        return this.worker.getFontHeight(this.gdef.largeFont);
    }

    private double getSmallFontCharWidth() {
        return this.worker.getStringWidth("a", this.gdef.smallFont);
    }

    double getInterlegendSpace() {
        return this.getSmallFontCharWidth() * 2.0;
    }

    double getLeading() {
        return this.getSmallFontHeight() * 1.2;
    }

    double getSmallLeading() {
        return this.getSmallFontHeight() * 0.7;
    }

    double getBoxSpace() {
        return Math.ceil(this.getSmallFontHeight() * 1.2);
    }

    private double getBox() {
        return this.getSmallFontHeight() * 0.9;
    }

    double[] xtr(long[] lArray) {
        double[] dArray = new double[2 * lArray.length - 1];
        int n = 0;
        int n2 = 0;
        while (n < lArray.length) {
            dArray[n2] = this.mapper.xtr(lArray[n]);
            if (n < lArray.length - 1) {
                dArray[n2 + 1] = dArray[n2];
            }
            ++n;
            n2 += 2;
        }
        return dArray;
    }

    double[] ytr(double[] dArray) {
        double[] dArray2 = new double[2 * dArray.length - 1];
        int n = 0;
        int n2 = 0;
        while (n < dArray.length) {
            dArray2[n2] = Double.isNaN(dArray[n]) ? Double.NaN : (double)this.mapper.ytr(dArray[n]);
            if (n2 > 0) {
                dArray2[n2 - 1] = dArray2[n2];
            }
            ++n;
            n2 += 2;
        }
        return dArray2;
    }

    public void render(Graphics graphics) {
        byte[] byArray = this.getRrdGraphInfo().getBytes();
        ImageIcon imageIcon = new ImageIcon(byArray);
        imageIcon.paintIcon(null, graphics, 0, 0);
    }
}

