/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.eventing.mgmt;

import java.net.URI;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.extensions.eventing.mgmt.DispatcherFactory;
import org.jboss.ws.extensions.eventing.mgmt.EventDispatcher;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManager;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
import org.w3c.dom.Element;

public class DispatcherDelegate
implements EventDispatcher,
Referenceable {
    private static final Logger log = Logger.getLogger(DispatcherDelegate.class);
    private String hostname;
    public static final String MANAGER_HOSTNAME = "manager.hostname";
    private SubscriptionManagerMBean subscriptionManager = null;

    public DispatcherDelegate() {
    }

    public DispatcherDelegate(String hostname) {
        this.setHostname(hostname);
    }

    public void dispatch(URI eventSourceNS, Element payload) {
        this.getSubscriptionManager().dispatch(eventSourceNS, payload);
    }

    public Reference getReference() throws NamingException {
        Reference myRef = new Reference(DispatcherDelegate.class.getName(), DispatcherFactory.class.getName(), null);
        myRef.add(new StringRefAddr(MANAGER_HOSTNAME, this.hostname));
        return myRef;
    }

    private SubscriptionManagerMBean getSubscriptionManager() {
        if (null == this.subscriptionManager) {
            try {
                ObjectName objectName = SubscriptionManager.OBJECT_NAME;
                this.subscriptionManager = MBeanServerInvocationHandler.newProxyInstance(this.getServer(), objectName, SubscriptionManagerMBean.class, false);
            }
            catch (Exception e) {
                throw new WSException("Failed to access subscription manager: " + e.getMessage());
            }
        }
        return this.subscriptionManager;
    }

    private MBeanServerConnection getServer() throws NamingException {
        MBeanServerConnection server = this.locateJBoss();
        if (null == server) {
            InitialContext iniCtx = new InitialContext();
            server = (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
            log.debug((Object)"Using RMI invocation");
        } else {
            log.debug((Object)"Using in-VM invocation");
        }
        return server;
    }

    public MBeanServerConnection locateJBoss() {
        MBeanServer jboss = null;
        for (MBeanServer server : MBeanServerFactory.findMBeanServer(null)) {
            if (!server.getDefaultDomain().equals("jboss")) continue;
            jboss = server;
        }
        return jboss;
    }

    void setHostname(String hostname) {
        if (null == hostname) {
            throw new IllegalArgumentException("Hostname may not be null");
        }
        this.hostname = hostname;
    }
}

