/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.server.config;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.portal.common.util.CLResourceLoader;
import org.jboss.portal.common.util.LoaderResource;
import org.jboss.portal.server.config.ServerConfig;

public class ServerConfigService
implements ServerConfig {
    private final String domain = "portal";
    private String configLocation;
    private LoaderResource configResource;
    private Map properties = new HashMap();

    public String getDomain() {
        return "portal";
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public LoaderResource getConfigResource() {
        return this.configResource;
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("No null name accepted");
        }
        ServerConfigService serverConfigService = this;
        synchronized (serverConfigService) {
            HashMap<String, String> copy = new HashMap<String, String>(this.properties);
            if (value != null) {
                value = value.trim();
                copy.put(name, value);
            } else {
                copy.remove(name);
            }
            this.properties = copy;
        }
    }

    public String dumpProperties(boolean html) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry entry : new TreeMap(this.properties).entrySet()) {
            buffer.append(entry.getKey()).append("=").append(entry.getValue()).append(html ? "<br/>" : "\n");
        }
        return buffer.toString();
    }

    public void create() throws Exception {
        this.configResource = new CLResourceLoader().getResource(this.configLocation);
        if (this.configResource.exists()) {
            this.properties.clear();
            this.properties.putAll(this.configResource.asProperties(true));
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            String value = (String)entry.getValue();
            value = value.trim();
            entry.setValue(value);
        }
        this.properties.put("server.domain", "portal");
    }

    public void destroy() throws Exception {
        this.properties.clear();
        this.configResource = null;
    }
}

