/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller.request;

import java.util.Map;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.cache.CacheLevel;
import org.jboss.portal.portlet.controller.request.ContainerRequest;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletResourceRequest
extends ContainerRequest {
    private final String resourceId;
    private final StateString resourceState;
    private final Map<String, String[]> bodyParameters;
    private final Scope scope;

    public PortletResourceRequest(String windowId, String resourceId, StateString resourceState, Map<String, String[]> bodyParameters, Scope scope) throws IllegalArgumentException {
        super(windowId);
        if (resourceState == null) {
            throw new IllegalArgumentException("No null resource state provided");
        }
        if (scope == null) {
            throw new IllegalArgumentException("No null scope provided");
        }
        this.resourceId = resourceId;
        this.resourceState = resourceState;
        this.bodyParameters = bodyParameters;
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public CacheLevel getCacheability() {
        return this.scope.getCacheability();
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public StateString getResourceState() {
        return this.resourceState;
    }

    public Map<String, String[]> getBodyParameters() {
        return this.bodyParameters;
    }

    @Override
    public PortletPageNavigationalState getPageNavigationalState() {
        if (this.scope instanceof PageScope) {
            return ((PageScope)this.scope).getPageNavigationalState();
        }
        return null;
    }

    public static class PageScope
    extends PortletScope {
        private final PortletPageNavigationalState pageNavigationalState;

        public PageScope(PortletWindowNavigationalState windowNavigationalState, PortletPageNavigationalState pageNavigationalState) {
            super(windowNavigationalState);
            this.pageNavigationalState = pageNavigationalState;
        }

        public PortletPageNavigationalState getPageNavigationalState() {
            return this.pageNavigationalState;
        }

        public CacheLevel getCacheability() {
            return CacheLevel.PAGE;
        }
    }

    public static class PortletScope
    extends FullScope {
        private final PortletWindowNavigationalState windowNavigationalState;

        public PortletScope(PortletWindowNavigationalState windowNavigationalState) {
            this.windowNavigationalState = windowNavigationalState;
        }

        public PortletWindowNavigationalState getWindowNavigationalState() {
            return this.windowNavigationalState;
        }

        public CacheLevel getCacheability() {
            return CacheLevel.PORTLET;
        }
    }

    public static class FullScope
    extends Scope {
        public CacheLevel getCacheability() {
            return CacheLevel.FULL;
        }
    }

    public static abstract class Scope {
        public abstract CacheLevel getCacheability();
    }
}

