/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.el;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.faces.el.PropertyValue;
import org.jboss.portal.faces.el.dynamic.DynamicBean;

public class ClassConstantPublisherBean
implements DynamicBean {
    private String className;
    private volatile Map entries;

    private static Map getEntries(Class clazz) {
        Class superClazz = clazz.getSuperclass();
        Map<String, Object> entries = clazz.getSuperclass() == null ? new HashMap() : ClassConstantPublisherBean.getEntries(superClazz);
        try {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
                Object value = field.get(null);
                entries.put(field.getName(), value);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return entries;
    }

    private Map getEntries() {
        if (this.entries == null) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.className);
                this.entries = ClassConstantPublisherBean.getEntries(clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.entries;
    }

    public Class getType(Object propertyName) throws IllegalArgumentException {
        if ("className".equals(propertyName)) {
            return String.class;
        }
        Map entries = this.getEntries();
        Object value = entries.get(propertyName);
        return value != null ? value.getClass() : null;
    }

    public PropertyValue getValue(Object propertyName) throws IllegalArgumentException {
        if ("className".equals(propertyName)) {
            return new PropertyValue(this.className);
        }
        Map entries = this.getEntries();
        Object value = entries.get(propertyName);
        return new PropertyValue(value);
    }

    public boolean setValue(Object propertyName, Object value) throws IllegalArgumentException {
        if ("className".equals(propertyName)) {
            this.className = (String)value;
            return true;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

