/*
 * Decompiled with CFR 0.152.
 */
package com.osivia.portail.site.portlets.solutions;

import com.osivia.portail.site.portlets.solutions.ListeSolutionsCommand;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.jaxrs.model.Documents;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class PortletSolutions
extends CMSPortlet {
    protected static final Log logger = LogFactory.getLog(PortletSolutions.class);
    private IPortalUrlFactory portalUrlFactory;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.portalUrlFactory = (IPortalUrlFactory)this.getPortletContext().getAttribute("UrlService");
        if (this.portalUrlFactory == null) {
            throw new PortletException("Cannot start PortletSolutions due to service unavailability");
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        block4: {
            try {
                response.setContentType("text/html");
                NuxeoController nuxeoCtrl = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String solutionSPath = window.getProperty("solutions.path");
                if (solutionSPath == null) {
                    response.setContentType("text/html");
                    response.getWriter().print("<h2>Document non d\u00e9fini</h2>");
                    response.getWriter().close();
                    return;
                }
                Documents docs = (Documents)nuxeoCtrl.executeNuxeoCommand((INuxeoCommand)new ListeSolutionsCommand(solutionSPath));
                request.setAttribute("docs", (Object)docs);
                request.setAttribute("nuxeoCtrl", (Object)nuxeoCtrl);
                PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/view.jsp");
                dispatcher.include(request, response);
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                if (e instanceof PortletException) break block4;
                throw new PortletException((Throwable)e);
            }
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String path = window.getProperty("solutions.path");
        if (path == null) {
            path = "";
        }
        req.setAttribute("path", (Object)path);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/admin.jsp");
        rd.include(req, res);
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("modifierPrefs") != null) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
            String path = req.getParameter("path");
            if (path != null && path.length() > 0) {
                window.setProperty("solutions.path", path);
            } else {
                window.setProperty("solutions.path", null);
            }
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
    }
}

