/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.site.customizer;

import java.util.Arrays;
import java.util.Map;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.CustomizationModuleMetadatas;
import org.osivia.portal.api.customization.ICustomizationModule;
import org.osivia.portal.api.customization.ICustomizationModulesRepository;
import org.osivia.portal.api.theming.IRenderedRegions;

public class RegionsCustomizerPortlet
extends GenericPortlet
implements ICustomizationModule {
    private static final String OSIVIA_SITE_CHARTE_COMMERCIAL_CONTEXT_PATH_INIT_PARAM = "osivia.site.customizer.regions.osivia-site-charte-commercial.context";
    private static final String OSIVIA_SITE_CHARTE_COMMUNITY_CONTEXT_PATH_INIT_PARAM = "osivia.site.customizer.regions.osivia-site-charte-community.context";
    private static final String CUSTOMIZER_NAME = "osivia.site.customizer.regions.name";
    private static final String ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY = "CustomizationModulesRepository";
    private ICustomizationModulesRepository repository;
    private final CustomizationModuleMetadatas metadatas = this.generateMetadatas();

    private CustomizationModuleMetadatas generateMetadatas() {
        CustomizationModuleMetadatas metadatas = new CustomizationModuleMetadatas();
        metadatas.setName(CUSTOMIZER_NAME);
        metadatas.setModule((ICustomizationModule)this);
        metadatas.setCustomizationIDs(Arrays.asList("osivia.customizer.regions.id"));
        return metadatas;
    }

    public void init() throws PortletException {
        super.init();
        this.repository = (ICustomizationModulesRepository)this.getPortletContext().getAttribute(ATTRIBUTE_CUSTOMIZATION_MODULES_REPOSITORY);
        this.repository.register(this.metadatas);
    }

    public void destroy() {
        super.destroy();
        this.repository.unregister(this.metadatas);
    }

    public void customize(String customizationID, CustomizationContext context) {
        String charteCommercialContextPath = this.getInitParameter(OSIVIA_SITE_CHARTE_COMMERCIAL_CONTEXT_PATH_INIT_PARAM);
        String charteCommunityContextPath = this.getInitParameter(OSIVIA_SITE_CHARTE_COMMUNITY_CONTEXT_PATH_INIT_PARAM);
        Map attributes = context.getAttributes();
        String contextPath = (String)attributes.get("osivia.customizer.regions.themeContextPath");
        if (StringUtils.equals((String)contextPath, (String)charteCommercialContextPath) || StringUtils.equals((String)contextPath, (String)charteCommunityContextPath)) {
            IRenderedRegions renderedRegion = (IRenderedRegions)attributes.get("osivia.customizer.regions.renderedRegions");
            if (StringUtils.equals((String)contextPath, (String)charteCommercialContextPath)) {
                renderedRegion.removeRenderedRegion("breadcrumb");
                renderedRegion.customizeRenderedRegion("title", "/header/title.jsp");
            }
            if (StringUtils.equals((String)contextPath, (String)charteCommunityContextPath)) {
                renderedRegion.customizeRenderedRegion("toolbar", "/header/toolbar.jsp");
                renderedRegion.customizeRenderedRegion("logo", "/header/logo.jsp");
                renderedRegion.customizeRenderedRegion("tabs", "/header/tabs.jsp");
                renderedRegion.customizeRenderedRegion("footer", "/footer/footer.jsp");
            }
        }
    }
}

