/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.documentation;

import org.nuxeo.apidoc.snapshot.SnapshotManager;
import org.nuxeo.runtime.api.Framework;

public class JavaDocHelper {
    public static final String BASE_URL = "http://community.nuxeo.com/api/";
    public static final String CM_BASE = "nuxeo-case-management";
    public static final String DM_BASE = "nuxeo";
    public static final String DAM_BASE = "nuxeo-dam";
    public static final String DEFAULT_DIST = "nuxeo";
    public static final String DEFAULT_VERSION = "5.5";
    protected final String defaultPrefix;
    protected final String docVersion;

    public JavaDocHelper(String prefix, String version) {
        this.defaultPrefix = prefix;
        if (version.equalsIgnoreCase("current")) {
            SnapshotManager sm = (SnapshotManager)Framework.getLocalService(SnapshotManager.class);
            version = sm.getRuntimeSnapshot().getVersion();
        }
        version = version.endsWith("-SNAPSHOT") ? version.replace("-SNAPSHOT", "") : "release-" + version;
        this.docVersion = version;
    }

    public String getBaseUrl(String className) {
        String base = this.defaultPrefix;
        if (!this.docVersion.startsWith("5.")) {
            base = className.contains("org.nuxeo.cm") ? CM_BASE : (className.contains("org.nuxeo.dam") ? DAM_BASE : "nuxeo");
        }
        return BASE_URL + base + "/" + this.docVersion;
    }

    public static JavaDocHelper getHelper(String distribName, String distribVersion) {
        String base = "nuxeo";
        if (!distribVersion.startsWith("5.")) {
            if (distribName.toUpperCase().contains("CM") || distribName.toUpperCase().contains("CASE")) {
                base = CM_BASE;
            } else if (distribName.toUpperCase().contains("DAM")) {
                base = DAM_BASE;
            }
        }
        return new JavaDocHelper(base, distribVersion);
    }
}

