/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.uar.ecm.actions;

import fr.toutatice.ecm.platform.web.workflows.ToutaticeRoutingTaskActionsBean;
import fr.toutatice.services.uar.ecm.actions.UARActions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.comment.web.CommentManagerActionsBean;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;

@Name(value="uarAction")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=30)
public class UARActionsBean
implements UARActions,
Serializable {
    private static final long serialVersionUID = 7595156889276329779L;
    private static final String TYPEMIME_INTERDIT = "application/zip, application/x-compressed, application/x-zip-compressed, application/x-rar-compressed,application/x-tar,application/x-gzip, application/x-7z-compressed, application/x-xz";
    private static final String XPATH_LST_NO_COMPTE = "uarf:noCompte";
    private static final String TYPE_IMPRESSION = "uar-demande-impression";
    private static final String TYPE_DOSSIER_IMPRESSION = "uar-demande-impression-dossier";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient CommentManagerActionsBean commentManagerActions;
    private static final Log log = LogFactory.getLog(UARActionsBean.class);

    public void validateComment(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String comment = (String)value;
        ToutaticeRoutingTaskActionsBean taskAction = (ToutaticeRoutingTaskActionsBean)SeamComponentCallHelper.getSeamComponentByName((String)"routingTaskActions");
        String buttonName = taskAction.getClickedButton();
        try {
            if (StringUtils.isBlank((String)comment) && "commentOk".equals(buttonName)) {
                String msg = ComponentUtils.translate((FacesContext)context, (String)"label.toutatice.uar.justifier.refus.impression");
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                throw new ValidatorException(message);
            }
        }
        catch (PatternSyntaxException pse) {
            log.error((Object)pse.getMessage());
        }
    }

    public String[] getlstNoCompte() {
        String[] lstNoCompte = new String[2];
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc.getType().equals(TYPE_DOSSIER_IMPRESSION)) {
            lstNoCompte = (String[])currentDoc.getPropertyValue(XPATH_LST_NO_COMPTE);
        } else if (currentDoc.getType().equals(TYPE_IMPRESSION)) {
            DocumentModel parent = this.documentManager.getParentDocument(currentDoc.getRef());
            lstNoCompte = (String[])parent.getPropertyValue(XPATH_LST_NO_COMPTE);
        }
        return lstNoCompte;
    }

    public void validateFile(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        InputFileInfo fileInfo = (InputFileInfo)value;
        String mimeType = (String)fileInfo.getMimeType();
        if (TYPEMIME_INTERDIT.contains(mimeType)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_WARN, "Les fichiers zip, gzip, tar, 7z et xz ne sont pas autoris\u00e9s", null);
            throw new ValidatorException(message);
        }
    }

    public List<SelectEntry> getPrincipalSelectEntries() {
        return this.getFilteredEntries("uar-type-imprimante", false);
    }

    public List<SelectEntry> getTypeSupportEntries() {
        return this.getFilteredEntries("uar-type-support2", true);
    }

    private String getPropertyValCurrentDoc(String xpath) {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        String val = null;
        if (currentDoc != null && currentDoc.getType().equals(TYPE_DOSSIER_IMPRESSION)) {
            currentDoc = this.navigationContext.getChangeableDocument();
        }
        if (currentDoc != null) {
            val = (String)((Object)currentDoc.getPropertyValue(xpath));
        }
        return val;
    }

    public List<SelectEntry> getCouleurSupportEntries() {
        return this.getFilteredEntries("uar-child-couleur", true);
    }

    public List<SelectEntry> getCouvertureDebEntries() {
        return this.getFilteredEntries("uar-child-couverture", true);
    }

    public List<SelectEntry> getCouvertureFinEntries() {
        return this.getFilteredEntries("uar-child-couverture", true);
    }

    private List<SelectEntry> getFilteredEntries(String directoryName, boolean existFilter) {
        ArrayList<SelectEntry> items = new ArrayList<SelectEntry>();
        DocumentModelListImpl entries = new DocumentModelListImpl();
        Session directorySession = null;
        String typeImprimanteId = this.getPropertyValCurrentDoc("uar:typeImprimante");
        HashMap<String, String> filter = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)typeImprimanteId) || !existFilter) {
            try {
                DirectoryService service = DirectoryHelper.getDirectoryService();
                directorySession = service.open(directoryName);
            }
            catch (Exception e) {
                log.error((Object)String.format("Error when retrieving directory %s", "uar-type-support2"), (Throwable)e);
            }
            if (existFilter) {
                filter.put("parent", typeImprimanteId);
            }
            entries = directorySession.query(filter);
            items.add(new SelectEntry(" ", "S\u00e9lectionner une valeur", "0"));
            for (DocumentModel entry : entries) {
                String schema = entry.getSchemas()[0];
                SelectEntry item = new SelectEntry((String)((Object)entry.getPropertyValue(schema + ":id")), (String)((Object)entry.getPropertyValue(schema + ":label")), entry.getPropertyValue(schema + ":ordering").toString());
                items.add(item);
            }
        } else {
            items.add(new SelectEntry(" ", "S\u00e9lectionner un type d'imprimante", "0"));
        }
        Collections.sort(items);
        return items;
    }

    public static class SelectEntry
    implements Comparable<SelectEntry> {
        public String value;
        public String label;
        public String order;

        public SelectEntry(String value, String label, String order) {
            this.value = value;
            this.label = label;
            this.order = order;
        }

        public String getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(SelectEntry arg0) {
            String order = arg0.getOrder();
            String label = arg0.getLabel();
            int res = this.getOrder().compareTo(order);
            if (res == 0) {
                res = this.getLabel().compareTo(label);
            }
            return res;
        }
    }
}

