/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.relations;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.relations.CoreGraph;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.GraphDescription;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.QueryResult;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.jena.JenaGraph;

public class AcrennesGraph
implements Graph {
    private static final long serialVersionUID = 7755961270980547369L;
    private static final Log log = LogFactory.getLog(AcrennesGraph.class);
    protected CoreSession session;
    private Graph coreGraph;
    private Graph jenaGraph;

    public AcrennesGraph(CoreSession session) {
        this.session = session;
        this.coreGraph = new CoreGraph(session);
        this.jenaGraph = new JenaGraph();
    }

    public void setDescription(GraphDescription graphDescription) {
        this.coreGraph.setDescription(graphDescription);
        this.jenaGraph.setDescription(graphDescription);
    }

    public Map<String, String> getNamespaces() {
        return this.coreGraph.getNamespaces();
    }

    public void add(Statement statement) {
        this.coreGraph.add(statement);
    }

    public void add(List<Statement> statements) {
        this.coreGraph.add(statements);
    }

    public void remove(Statement statement) {
        try {
            this.jenaGraph.remove(statement);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to remove the statement from the Jena qraph, error: " + e.getMessage()));
        }
        try {
            this.coreGraph.remove(statement);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to remove the statement from the core qraph, error: " + e.getMessage()));
        }
    }

    public void remove(List<Statement> statements) {
        try {
            this.jenaGraph.remove(statements);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to remove the statements from the Jena qraph, error: " + e.getMessage()));
        }
        try {
            this.coreGraph.remove(statements);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to remove the statements from the core qraph, error: " + e.getMessage()));
        }
    }

    public List<Statement> getStatements() {
        ArrayList<Statement> list = new ArrayList<Statement>();
        list.addAll(this.jenaGraph.getStatements());
        list.addAll(this.coreGraph.getStatements());
        return list;
    }

    public List<Statement> getStatements(Statement statement) {
        ArrayList<Statement> list = new ArrayList<Statement>();
        list.addAll(this.jenaGraph.getStatements(statement));
        list.addAll(this.coreGraph.getStatements(statement));
        return list;
    }

    public List<Statement> getStatements(Node subject, Node predicate, Node object) {
        ArrayList<Statement> list = new ArrayList<Statement>();
        list.addAll(this.jenaGraph.getStatements(subject, predicate, object));
        list.addAll(this.coreGraph.getStatements(subject, predicate, object));
        return list;
    }

    public List<Node> getSubjects(Node predicate, Node object) {
        ArrayList<Node> list = new ArrayList<Node>();
        list.addAll(this.jenaGraph.getSubjects(predicate, object));
        list.addAll(this.coreGraph.getSubjects(predicate, object));
        return list;
    }

    public List<Node> getPredicates(Node subject, Node object) {
        ArrayList<Node> list = new ArrayList<Node>();
        list.addAll(this.jenaGraph.getSubjects(subject, object));
        list.addAll(this.coreGraph.getSubjects(subject, object));
        return list;
    }

    public List<Node> getObjects(Node subject, Node predicate) {
        ArrayList<Node> list = new ArrayList<Node>();
        list.addAll(this.jenaGraph.getSubjects(subject, predicate));
        list.addAll(this.coreGraph.getSubjects(subject, predicate));
        return list;
    }

    public boolean hasStatement(Statement statement) {
        return this.jenaGraph.hasStatement(statement) || this.coreGraph.hasStatement(statement);
    }

    public boolean hasResource(Resource resource) {
        return this.jenaGraph.hasResource(resource) || this.coreGraph.hasResource(resource);
    }

    public Long size() {
        return this.jenaGraph.size() + this.coreGraph.size();
    }

    public void clear() {
        this.jenaGraph.clear();
        this.coreGraph.clear();
    }

    public QueryResult query(String queryString, String language, String baseURI) {
        return this.jenaGraph.query(queryString, language, baseURI);
    }

    public boolean read(String path, String lang, String base) {
        boolean status = false;
        try {
            status = this.jenaGraph.read(path, lang, base);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to read from the Jena qraph, error: " + e.getMessage()));
        }
        try {
            status = this.coreGraph.read(path, lang, base);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to read from the core qraph, error: " + e.getMessage()));
        }
        return status;
    }

    public boolean read(InputStream in, String lang, String base) {
        boolean status = false;
        try {
            status = this.jenaGraph.read(in, lang, base);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to read from the Jena qraph, error: " + e.getMessage()));
        }
        try {
            status = this.coreGraph.read(in, lang, base);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to read from the core qraph, error: " + e.getMessage()));
        }
        return status;
    }

    public boolean write(String path, String lang, String base) {
        return this.coreGraph.write(path, lang, base);
    }

    public boolean write(OutputStream out, String lang, String base) {
        return this.coreGraph.write(out, lang, base);
    }
}

