/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.services;

import fr.toutatice.ecm.acrennes.core.services.AcrennesUserWorkspaceService;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class UserworkspaceCreationWork
extends AbstractWork {
    public static final String UWS_CATEGORY = "USERWORKSPACE_CREATION";
    public static final String UWS_QUEUE_ID = "userworkspaces-creation-queue";
    private static final Log uwLog = LogFactory.getLog((String)"fr.toutatice.userworkspaces");
    private static final long serialVersionUID = -9034677557639603196L;
    private final String username;

    public UserworkspaceCreationWork(String username) {
        super("USERWORKSPACE_CREATION/" + username);
        this.username = username;
    }

    public void work() throws Exception {
        this.initSession();
        UserWorkspaceService service = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        if (!(service instanceof AcrennesUserWorkspaceService)) {
            throw new UnsupportedOperationException("Service AcrennesUserWorkspaceService introuvable");
        }
        AcrennesUserWorkspaceService acrService = (AcrennesUserWorkspaceService)service;
        acrService.asyncCreateUserWorkspace(this.session, this.username);
        Date now = new Date();
        long elasped = now.getTime() - this.getStartTime();
        long scheduled = now.getTime() - this.getSchedulingTime();
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        int queueSize = workManager.getQueueSize(UWS_QUEUE_ID, null) - 1;
        uwLog.info((Object)("Cr\u00e9ation espace " + this.getTitle() + ", temps d'attente " + scheduled + "ms, temps d'ex\u00e9cution : " + elasped + "ms, taille file d'attente : " + queueSize));
    }

    public String getCategory() {
        return UWS_CATEGORY;
    }

    public String getUsername() {
        return this.username;
    }

    public String getTitle() {
        return this.getId();
    }
}

