/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.builder;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

public class PublishableDocumentFinder {
    private static final String PUBLISHABLE_DOC_QUERY = "select * from Document where ttc:webid = '%s' and ecm:isVersion = 1 and ecm:currentLifeCycleState = 'approved' and ecm:mixinType <> 'HiddenInNavigation' order by dc:modified desc";
    private DocumentModel publishableDoc;
    private static PublishableDocumentFinder instance;

    private PublishableDocumentFinder() {
    }

    public static synchronized PublishableDocumentFinder getInstance() {
        if (instance == null) {
            instance = new PublishableDocumentFinder();
        }
        return instance;
    }

    public DocumentModel getPublishableDocument(CoreSession session, DocumentModel document) {
        DocumentModel publishableDoc = null;
        if ("approved".equals(document.getCurrentLifeCycleState())) {
            publishableDoc = document;
        } else {
            String query = String.format(PUBLISHABLE_DOC_QUERY, (String)((Object)document.getPropertyValue("ttc:webid")));
            DocumentModelList publishableDocs = ToutaticeEsQueryHelper.query((CoreSession)session, (String)query, (int)1);
            if (CollectionUtils.isNotEmpty((Collection)publishableDocs)) {
                publishableDoc = (DocumentModel)publishableDocs.get(0);
            }
        }
        return publishableDoc;
    }

    public DocumentModel getPublishableDoc() {
        return this.publishableDoc;
    }

    public void setPublishableDoc(DocumentModel publishableDoc) {
        this.publishableDoc = publishableDoc;
    }
}

