/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.components;

import fr.toutatice.ecm.platform.core.components.ToutaticeAbstractServiceHandler;
import fr.toutatice.ecm.platform.core.services.maintenance.ToutaticeMaintenanceService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.runtime.api.Framework;

public class ToutaticeAutomationServiceHandler<T>
extends ToutaticeAbstractServiceHandler<T> {
    private static final Log log = LogFactory.getLog(ToutaticeAutomationServiceHandler.class);
    private ToutaticeMaintenanceService mntService;

    @Override
    public T newProxy(T object, Class<T> itf) {
        this.setObject(object);
        return itf.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{itf}, (InvocationHandler)this));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String ops = "";
        String inputStg = "";
        String uid = "";
        String type = "";
        String principalStg = "";
        CoreSession session = null;
        try {
            if ("run".equals(method.getName()) && log.isDebugEnabled()) {
                for (Object arg : args) {
                    Principal principal;
                    if (arg instanceof String) {
                        ops = "operation " + (String)arg;
                        continue;
                    }
                    if (arg instanceof OperationChain) {
                        OperationChain opc = (OperationChain)arg;
                        ops = "chain " + opc.getId() + " (";
                        List operations = opc.getOperations();
                        for (OperationParameters operation : operations) {
                            ops = ops + operation.id() + " {";
                            Map params = operation.map();
                            if (0 < params.size()) {
                                Set paramKS = params.keySet();
                                for (String pk : paramKS) {
                                    Object value = params.get(pk);
                                    if (!(value instanceof String)) continue;
                                    ops = ops + pk + ":" + (String)params.get(pk) + " ";
                                    if (null == session || !"path".equals(pk) && !"value".equals(pk)) continue;
                                    try {
                                        DocumentModel doc = session.getDocument((DocumentRef)new PathRef((String)value));
                                        uid = doc.getId();
                                        type = doc.getType();
                                    }
                                    catch (Exception e) {
                                        log.debug((Object)"might have no permission to fetch the document with the user session or not found");
                                    }
                                }
                            }
                            ops = ops.trim() + "} ";
                        }
                        ops = ops.trim() + ")";
                        continue;
                    }
                    if (!(arg instanceof OperationContext)) continue;
                    OperationContext oc = (OperationContext)arg;
                    Object input = oc.getInput();
                    session = oc.getCoreSession();
                    if (input instanceof DocumentModel && null != input) {
                        inputStg = ((DocumentModel)input).getPathAsString();
                        uid = ((DocumentModel)input).getId();
                        type = ((DocumentModel)input).getType();
                    }
                    if (null == (principal = oc.getPrincipal())) continue;
                    principalStg = principal.getName();
                }
                if (this.isLogEnabled(session)) {
                    long startTime = System.currentTimeMillis();
                    Object result = method.invoke(this.object, args);
                    long stopTime = System.currentTimeMillis();
                    if (stopTime - startTime > this.getLogThreshold(session)) {
                        log.debug((Object)String.format("Duration:%d ms - %s [input:%s, uid:%s, type:%s, principal:%s]", stopTime - startTime, ops, inputStg, uid, type, principalStg));
                    }
                    return result;
                }
                return method.invoke(this.object, args);
            }
            return method.invoke(this.object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private long getLogThreshold(CoreSession session) {
        this.mntService = this.getMntService();
        if (this.mntService == null) {
            return 1000L;
        }
        return this.mntService.getAutomationLogsThreshold(session);
    }

    private boolean isLogEnabled(CoreSession session) {
        boolean res = false;
        this.mntService = this.getMntService();
        if (this.mntService != null) {
            res = this.mntService.isAutomationLogsEnabled(session);
        }
        return res;
    }

    private ToutaticeMaintenanceService getMntService() {
        if (null == this.mntService) {
            this.mntService = (ToutaticeMaintenanceService)Framework.getLocalService(ToutaticeMaintenanceService.class);
        }
        return this.mntService;
    }
}

