/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.listener;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.mail.AuthenticationFailedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.platform.mail.utils.MailCoreHelper;

public class MailEventListener
implements EventListener {
    public static final String EVENT_NAME = "MailReceivedEvent";
    public static final String PIPE_NAME = "nxmail";
    public static final String INBOX = "INBOX";
    private static final Log log = LogFactory.getLog(MailEventListener.class);
    protected Lock lock = new ReentrantLock();

    public void handleEvent(Event event) {
        String eventId = event.getName();
        if (!EVENT_NAME.equals(eventId)) {
            return;
        }
        if (this.lock.tryLock()) {
            try {
                this.doHandleEvent(event);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            log.info((Object)"Skip email check since it is already running");
        }
    }

    public void doHandleEvent(Event event) {
        try (CoreSession coreSession = CoreInstance.openCoreSession(null);){
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM MailFolder ");
            query.append(String.format(" WHERE ecm:currentLifeCycleState != '%s' ", "deleted"));
            query.append(" AND ecm:isProxy = 0 ");
            DocumentModelList mailFolderList = coreSession.query(query.toString());
            for (DocumentModel currentMailFolder : mailFolderList) {
                try {
                    MailCoreHelper.checkMail(currentMailFolder, coreSession);
                }
                catch (AuthenticationFailedException e) {
                    log.warn((Object)"Error connecting to email account", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"MailEventListener error...", (Throwable)e);
        }
    }
}

