/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.editablewindows.types;

import fr.toutatice.ecm.platform.service.editablewindows.EwServiceException;
import fr.toutatice.ecm.platform.service.editablewindows.types.EditableWindow;
import fr.toutatice.ecm.platform.service.fragments.helpers.CriteriaListBeanHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;

public class CriteriaListFragment
implements EditableWindow {
    public static final String CRITERIA_LIST_SCHEMA = "criteria_list_fragments";
    public static final String CRITERIA_LIST_XPATH = "crtlistfgt:criteriaListFragment";

    @Override
    public String prepareCreation(DocumentModel document, String uri, String region, String belowUri, String code2) throws EwServiceException {
        try {
            Map properties = document.getProperties(CRITERIA_LIST_SCHEMA);
            Collection values = properties.values();
            Object liste = values.iterator().next();
            if (liste instanceof List) {
                List listeData = (List)liste;
                HashMap<String, Object> newEntry = new HashMap<String, Object>(1);
                newEntry.put("refURI", uri);
                HashMap<String, String> criteriaRequest = new HashMap<String, String>(3);
                criteriaRequest.put("order", CriteriaListBeanHelper.Order.publicationDate.value());
                criteriaRequest.put("searchArea", CriteriaListBeanHelper.SearchArea.currentPage.value());
                criteriaRequest.put("currentDocId", document.getId());
                criteriaRequest.put("currentSpaceId", CriteriaListFragment.getSpaceId(document));
                newEntry.put("requestCriteria", criteriaRequest);
                HashMap<String, String> criteriaDisplay = new HashMap<String, String>(2);
                criteriaDisplay.put("nbItems", String.valueOf(10));
                criteriaDisplay.put("nbItemsPerPage", String.valueOf(10));
                newEntry.put("displayCriteria", criteriaDisplay);
                newEntry.put("style", "normal");
                listeData.add(newEntry);
                document.setProperties(CRITERIA_LIST_SCHEMA, properties);
            }
        }
        catch (ClientException e) {
            throw new EwServiceException((Exception)((Object)e));
        }
        return uri;
    }

    public static String getSpaceId(DocumentModel document) {
        String spaceId = (String)((Object)document.getPropertyValue("ttc:spaceID"));
        if (document.hasFacet("TTCPublishSpace")) {
            spaceId = document.getId();
        }
        return spaceId;
    }
}

