/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.fragments.helpers;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="criteriaListHelper")
@Scope(value=ScopeType.SESSION)
@Install(precedence=31)
public class CriteriaListBeanHelper
implements Serializable {
    private static final long serialVersionUID = 9151077743052798077L;
    public static final int NB_REQUEST_RESULTS = 10;
    public static final int NB_REQUEST_RESULTS_PER_PAGE = 10;
    public static final String COMPLEX_PROPERTY_SEPARATOR = "/";
    @In(create=true)
    protected NavigationContext navigationContext;
    protected String newKeyWord;

    public String getNewKeyWord() {
        return this.newKeyWord;
    }

    public void setNewKeyWord(String newKeyWord) {
        this.newKeyWord = newKeyWord;
    }

    public DocType[] getDocTypes() {
        return DocType.values();
    }

    public Order[] getOrders() {
        return Order.values();
    }

    public SearchArea[] getSearchAreas() {
        return SearchArea.values();
    }

    public String getKeyWordXPath() {
        return "crtlistfgt:criteriaListFragment";
    }

    public String getKeyWordsProperty(String xpath, int index) {
        StringBuffer keyWordsProperty = new StringBuffer().append(xpath).append(COMPLEX_PROPERTY_SEPARATOR).append(String.valueOf(index)).append(COMPLEX_PROPERTY_SEPARATOR).append("requestCriteria").append(COMPLEX_PROPERTY_SEPARATOR).append("keyWords");
        return keyWordsProperty.toString();
    }

    public void addKeyWord(String xpath, int index) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String keyWord = StringUtils.trim((String)this.newKeyWord);
        this.newKeyWord = "";
        String keyWordsProperty = this.getKeyWordsProperty(xpath, index);
        Object[] keyWordsValue = (String[])currentDocument.getPropertyValue(keyWordsProperty);
        if (keyWordsValue == null) {
            keyWordsValue = new String[]{};
        }
        keyWordsValue = (String[])ArrayUtils.add((Object[])keyWordsValue, (Object)keyWord);
        currentDocument.setPropertyValue(keyWordsProperty, (Serializable)keyWordsValue);
    }

    public void removeKeyWord(String xpath, int index) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        String keyWordsProperty = this.getKeyWordsProperty(xpath, index);
        Object[] keyWordsValue = (String[])currentDocument.getPropertyValue(keyWordsProperty);
        FacesContext context = FacesContext.getCurrentInstance();
        String keyWordToDel = (String)context.getExternalContext().getRequestParameterMap().get("keyWordToDel");
        keyWordsValue = (String[])ArrayUtils.removeElement((Object[])keyWordsValue, (Object)keyWordToDel);
        currentDocument.setPropertyValue(keyWordsProperty, (Serializable)keyWordsValue);
    }

    public static enum SearchArea {
        currentPage("ecm:parentId", "osivia.fragment.criteria.list.place.current.title"),
        fromCurrentPage("ecm:ancestorId", "osivia.fragment.criteria.list.place.childs.title"),
        space("ttc:spaceID", "osivia.fragment.criteria.list.place.space.title");

        private String nxProperty;
        private String label;

        private SearchArea(String nxProperty, String label) {
            this.nxProperty = nxProperty;
            this.label = label;
        }

        public String value() {
            return this.nxProperty;
        }

        public String label() {
            return this.label;
        }
    }

    public static enum Order {
        publicationDate("dc:issued desc", "osivia.fragment.criteria.list.order.publication.title"),
        alphabetic("dc:title asc", "osivia.fragment.criteria.list.order.alphabetic.title");

        private String nxProperty;
        private String label;

        private Order(String nxProperty, String label) {
            this.nxProperty = nxProperty;
            this.label = label;
        }

        public String value() {
            return this.nxProperty;
        }

        public String label() {
            return this.label;
        }
    }

    public static enum DocType {
        Article("Annonce", "osivia.fragment.criteria.list.doctype.article.title"),
        File("File", "osivia.fragment.criteria.list.doctype.file.title"),
        Link("ContextualLink", "osivia.fragment.criteria.list.doctype.link.title");

        private String nxType;
        private String label;

        private DocType(String nxType, String label) {
            this.nxType = nxType;
            this.label = label;
        }

        public String type() {
            return this.nxType;
        }

        public String label() {
            return this.label;
        }
    }
}

