/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.p1d.ecm.convert;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineBasedConverter;

public class Image2PDFConverter
extends CommandLineBasedConverter {
    private static final String TMP_PREFIX = "image2pdf_";
    private static final String PARAM_OUT_DIR_PATH = "outDirPath";
    private static final String PARAM_SOURCE_FILE_PATH = "sourceFilePath";
    private static final String PARAM_TARGET_FILE_PATH = "targetFilePath";
    private static final String PARAM_TARGET_FILE_NAME = "targetFileName";
    private static final List<String> RESERVED_PARAMETERS = Arrays.asList("outDirPath", "sourceFilePath", "targetFilePath", "targetFileName");

    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParams) {
        ArrayList<FileBlob> blobs = new ArrayList<FileBlob>();
        String outputPath = (String)cmdParams.getParameters().get(PARAM_OUT_DIR_PATH);
        File outputDir = new File(outputPath);
        if (outputDir.exists() && outputDir.isDirectory()) {
            File[] files;
            for (File file : files = outputDir.listFiles()) {
                FileBlob blob = new FileBlob(file);
                blob.setFilename(file.getName());
                blobs.add(blob);
            }
        }
        return new SimpleCachableBlobHolder(blobs);
    }

    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) {
        HashMap<String, Blob> cmdBlobParams = new HashMap<String, Blob>();
        cmdBlobParams.put(PARAM_SOURCE_FILE_PATH, blobHolder.getBlob());
        return cmdBlobParams;
    }

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) {
        String targetFilePath;
        HashMap<String, String> cmdStringParams = new HashMap<String, String>();
        String baseDir = this.getTmpDirectory(parameters);
        Path tmpPath = new Path(baseDir).append(TMP_PREFIX + System.currentTimeMillis());
        File outDir = new File(tmpPath.toString());
        if (!outDir.mkdir()) {
            throw new ConversionException("Unable to create tmp dir for transformer output");
        }
        cmdStringParams.put(PARAM_OUT_DIR_PATH, outDir.getAbsolutePath());
        String targetFileName = (String)((Object)parameters.get(PARAM_TARGET_FILE_NAME));
        if (targetFileName == null) {
            try {
                File tmpFile = File.createTempFile(blobHolder.getBlob().getFilename(), ".pdf", outDir);
                targetFilePath = tmpFile.getAbsolutePath();
                tmpFile.delete();
            }
            catch (IOException e) {
                throw new ConversionException("Unable to create tmp file for transformer output", (Exception)e);
            }
        } else {
            targetFilePath = outDir.getAbsolutePath() + System.getProperty("file.separator") + targetFileName;
        }
        cmdStringParams.put(PARAM_TARGET_FILE_PATH, targetFilePath);
        for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
            if (RESERVED_PARAMETERS.contains(entry.getKey())) continue;
            cmdStringParams.put(entry.getKey(), (String)((Object)entry.getValue()));
        }
        return cmdStringParams;
    }
}

