<#function escapeXML x="">
   <#return Fn.escapeXML(x?string)>
</#function>
<#list Properties as property>
	<#assign keys = property?keys>
	<#list keys as name>
		<#if property[name]??>
			<#if Fn.isComplexPropertyType(property[name])>
	<attr name="${name}">
		<value>
				<#assign complex_property = Fn.getProperties(Session, This, property[name])>
				<#assign propertiesXML = Fn.getPropertiesXML(Session, This, complex_property, 'template:propertiesXMLExport')>
				${propertiesXML}
		</value>
	</attr>
			<#elseif property[name]?is_sequence>
				<#if property[name]?size != 0>
	<attr name="${name}">
					<#list property[name] as value>
						<#if value?trim != "">
		<value>${value}</value>
						</#if>
					</#list>
	</attr>
				</#if>
			<#elseif Fn.isBlobType(property[name])>
				<#assign blob = Fn.getBlobTemplate(property[name])>
				<#assign blob_keys = blob?keys>
	<attr name="blob">
		<value>
				<#list blob_keys as item>
			<attr name="${item}">
				<value>${blob[item]}</value>
			</attr>
				</#list>
		</value>
	</attr>
			<#else>
				<#assign value = property[name]>
				<#if value?is_date>
	<attr name="${name}">
		<value>${value?date}</value>
	</attr>
				<#elseif value?trim != "">
	<attr name="${name}">
		<value>${escapeXML(value)}</value>
	</attr>
				</#if>
			</#if>
		</#if>
	</#list>
</#list>