/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.listener;

import fr.toutatice.ecm.acrennes.core.constants.AcrennesConstants;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDirectoryMngtHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeNotifyEventHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class AcrennesPropagateOrgSrcAsynchronouslyListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(AcrennesPropagateOrgSrcAsynchronouslyListener.class);

    public void handleEvent(EventBundle events) throws ClientException {
        for (Event event : events) {
            if (!"propagateOrganisationSource".equals(event.getName())) continue;
            this.handleEventPropagateOrgSource(event);
        }
    }

    public void handleEventPropagateOrgSource(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext eventContext = (DocumentEventContext)event.getContext();
            CoreSession session = eventContext.getCoreSession();
            DocumentModel document = eventContext.getSourceDocument();
            try {
                String srcOrg = (String)((Object)eventContext.getProperty("source"));
                String organisation = (String)((Object)eventContext.getProperty("organization"));
                if (StringUtils.isNotBlank((String)srcOrg) || StringUtils.isNotBlank((String)organisation)) {
                    ToutaticeSilentProcessRunnerHelper runner;
                    if (StringUtils.isNotBlank((String)srcOrg)) {
                        runner = new PropagateOrgSourceRunner(session, document, srcOrg);
                        runner.silentRun(false);
                        String srcOrgLabel = ToutaticeDirectoryMngtHelper.instance().getDirectoryEntriesLocalizedLabel(AcrennesConstants.CST_VOCABULARY_ORGANISATION_SOURCES, srcOrg, Locale.FRENCH);
                        ToutaticeNotifyEventHelper.notifyAuditEvent((CoreSession)session, (String)"propagateProcessCompleted", (DocumentModel)document, (String)String.format("Propagation de la source '%s' de l'espace '%s'", srcOrgLabel, document.getTitle()));
                    }
                    if (StringUtils.isNotBlank((String)organisation)) {
                        runner = new PropagateOrganisationRunner(session, document, organisation);
                        runner.silentRun(false);
                        ToutaticeNotifyEventHelper.notifyAuditEvent((CoreSession)session, (String)"propagateProcessCompleted", (DocumentModel)document, (String)String.format("Propagation de l'organisation '%s' de l'espace '%s'", organisation, document.getTitle()));
                    }
                } else {
                    ToutaticeNotifyEventHelper.notifyAuditEvent((CoreSession)session, (String)"propagateProcessCompleted", (DocumentModel)document, (String)String.format("Propagation de la source (pas de source/organisation) de l'espace '%s'", document.getTitle()));
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to apply the organisation source, error: " + e.getMessage()));
            }
            log.info((Object)("Fin du processus de propagation de la source depuis le document '" + document.getTitle() + "'"));
        }
    }

    private void propageOrganisation(DocumentModel container, String organisation, CoreSession session) {
        try {
            DocumentModelIterator childrenDocListItr = session.getChildrenIterator(container.getRef(), null, null, (Filter)new NotSetOrganisationFilter());
            while (childrenDocListItr.hasNext()) {
                DocumentModel child = (DocumentModel)childrenDocListItr.next();
                child.setPropertyValue("dc:publisher", (Serializable)((Object)organisation));
                session.saveDocument(child);
                if (!child.isFolder()) continue;
                this.propageOrganisation(child, organisation, session);
            }
        }
        catch (ClientException e) {
            log.error((Object)("Failed to apply the organisation source to the children of '" + container.getName() + "', error: " + e.getMessage()));
        }
    }

    private void propageSourceOrganisationnelle(DocumentModel container, String srcOrg, CoreSession session) {
        try {
            DocumentModelIterator childrenDocListItr = session.getChildrenIterator(container.getRef(), null, null, (Filter)new NotSetOrganisationSpaceFilter());
            while (childrenDocListItr.hasNext()) {
                DocumentModel child = (DocumentModel)childrenDocListItr.next();
                child.setPropertyValue("acr:publisher", (Serializable)((Object)srcOrg));
                session.saveDocument(child);
                if (!child.isFolder()) continue;
                this.propageSourceOrganisationnelle(child, srcOrg, session);
            }
        }
        catch (ClientException e) {
            log.error((Object)("Failed to apply the organisation source to the children of '" + container.getName() + "', error: " + e.getMessage()));
        }
    }

    private class NotSetOrganisationFilter
    implements Filter {
        private static final long serialVersionUID = 1L;

        private NotSetOrganisationFilter() {
        }

        public boolean accept(DocumentModel docModel) {
            boolean status = true;
            try {
                String org;
                if (docModel.isImmutable() || "deleted".equals(docModel.getCurrentLifeCycleState()) || docModel.hasFacet("HiddenInNavigation") || !docModel.hasSchema("dublincore")) {
                    return false;
                }
                if (ToutaticeDocumentHelper.isASpaceDocument((DocumentModel)docModel) && StringUtils.isNotBlank((String)(org = (String)((Object)docModel.getPropertyValue("dc:publisher"))))) {
                    status = false;
                }
            }
            catch (Exception e) {
                log.error((Object)("failed to evaluate the filter status on the document '" + docModel.getName() + "', error: " + e.getMessage()));
                status = false;
            }
            return status;
        }
    }

    private class NotSetOrganisationSpaceFilter
    implements Filter {
        private static final long serialVersionUID = 1L;

        private NotSetOrganisationSpaceFilter() {
        }

        public boolean accept(DocumentModel docModel) {
            boolean status = true;
            try {
                String srcOrg;
                if (docModel.isImmutable() || "deleted".equals(docModel.getCurrentLifeCycleState()) || docModel.hasFacet("HiddenInNavigation") || !docModel.hasSchema("acaren")) {
                    return false;
                }
                if (docModel.hasFacet("OrganisationSource") && StringUtils.isNotBlank((String)(srcOrg = (String)((Object)docModel.getPropertyValue("acr:publisher"))))) {
                    status = false;
                }
            }
            catch (Exception e) {
                log.error((Object)("failed to evaluate the filter status on the document '" + docModel.getName() + "', error: " + e.getMessage()));
                status = false;
            }
            return status;
        }
    }

    private class PropagateOrgSourceRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private String source;
        private DocumentModel baseDocument;

        public PropagateOrgSourceRunner(CoreSession session, DocumentModel baseDocument, String source) {
            super(session);
            this.baseDocument = baseDocument;
            this.source = source;
        }

        public void run() throws ClientException {
            DocumentModel currentDoc = this.baseDocument;
            if (null != currentDoc) {
                AcrennesPropagateOrgSrcAsynchronouslyListener.this.propageSourceOrganisationnelle(currentDoc, this.source, this.session);
            }
        }
    }

    private class PropagateOrganisationRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private String organisation;
        private DocumentModel baseDocument;

        public PropagateOrganisationRunner(CoreSession session, DocumentModel baseDocument, String organisation) {
            super(session);
            this.baseDocument = baseDocument;
            this.organisation = organisation;
        }

        public void run() throws ClientException {
            DocumentModel currentDoc = this.baseDocument;
            if (null != currentDoc) {
                AcrennesPropagateOrgSrcAsynchronouslyListener.this.propageOrganisation(currentDoc, this.organisation, this.session);
            }
        }
    }
}

