/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.services;

import java.security.Principal;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.userworkspace.core.service.DefaultUserWorkspaceServiceImpl;

public class AcrennesUserWorkspaceService
extends DefaultUserWorkspaceServiceImpl {
    private static final Log uwLog = LogFactory.getLog((String)"fr.toutatice.userworkspaces");
    private static final long serialVersionUID = 1L;
    protected static final String OLD_DOMAIN_NAME = "userworkspace-domain";
    protected static final String OLD_USERWORKSPACES_ROOT = "userworkspaces";
    protected static final int UW_PREFIX_SEGMENT_SIZE = 3;

    protected String computePathUserWorkspaceRoot(CoreSession userCoreSession, String usedUsername, DocumentModel currentDocument) throws ClientException {
        return StringUtils.substringBeforeLast((String)super.computePathUserWorkspaceRoot(userCoreSession, usedUsername, currentDocument), (String)"/UserWorkspaces");
    }

    protected PathRef resolveUserWorkspace(CoreSession session, PathRef homeDomainRef, String username, String workspacename, int maxsize) {
        PathRef usWsRef = null;
        String usWsName = super.getUserWorkspaceNameForUser(username);
        String usWsRootPath = this.computeOldPathUserWorkspaceRoot();
        Path usWsPath = this.computeUserWorspacePath(usWsRootPath, usWsName);
        usWsRef = new PathRef(usWsPath.toString());
        if (!session.exists((DocumentRef)usWsRef)) {
            usWsPath = this.computeUserWorspacePath(homeDomainRef.toString(), usWsName);
            usWsRef = new PathRef(usWsPath.toString());
        }
        return usWsRef;
    }

    protected String computeOldPathUserWorkspaceRoot() throws ClientException {
        return new Path("/userworkspace-domain").append(OLD_USERWORKSPACES_ROOT).toString();
    }

    protected Path computeUserWorspacePath(String rootPath, String usWsName) {
        Path usWsPath = new Path("/" + rootPath);
        for (int i = 0; i < usWsName.length() && i < 3; ++i) {
            usWsPath = usWsPath.append(usWsName.charAt(i) + "/");
        }
        usWsPath = usWsPath.append(usWsName);
        return usWsPath;
    }

    protected DocumentModel doCreateUserWorkspacesRoot(CoreSession unrestrictedSession, PathRef rootRef) throws ClientException {
        String parentPath = new Path(rootRef.toString()).removeLastSegments(1).toString();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, this.targetDomainName, this.getUserWorkspaceRootType());
        doc.setProperty("dublincore", "title", (Object)this.targetDomainName);
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        this.setUserWorkspaceRootACL(doc);
        return doc;
    }

    protected DocumentModel doCreateUserWorkspace(CoreSession unrestrictedSession, PathRef userWSRef, Principal principal, String userName) throws ClientException {
        DocumentModel uw = null;
        Path uwsPath = new Path(userWSRef.toString());
        for (int i = 2; i < uwsPath.segmentCount(); ++i) {
            PathRef nodeRef;
            if (uwLog.isDebugEnabled()) {
                uwLog.debug((Object)("    - Cr\u00e9ation du document " + uwsPath.uptoSegment(i).toString()));
            }
            if (unrestrictedSession.exists((DocumentRef)(nodeRef = new PathRef(uwsPath.uptoSegment(i).toString())))) continue;
            DocumentModel node = this.createUserWorkspacesRootSegment(unrestrictedSession, nodeRef);
            Validate.isTrue((boolean)node.getPathAsString().equals(nodeRef.toString()));
        }
        if (!unrestrictedSession.exists((DocumentRef)userWSRef)) {
            uwLog.info((Object)("Cr\u00e9ation du userWorkspace de [" + userName + "] : " + userWSRef.value));
            uw = this.createUserWorkspace(unrestrictedSession, userWSRef, userName);
            Validate.isTrue((boolean)uw.getPathAsString().equals(userWSRef.toString()));
        }
        if (uw != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("username", userName);
            this.notifyEvent(unrestrictedSession, uw, (NuxeoPrincipal)unrestrictedSession.getPrincipal(), "userWorkspaceCreated", properties);
        }
        return uw;
    }

    protected DocumentModel createUserWorkspacesRootSegment(CoreSession unrestrictedSession, PathRef rootRef) throws ClientException {
        String parentPath = new Path(rootRef.toString()).removeLastSegments(1).toString();
        String docName = new Path(rootRef.toString()).lastSegment();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, docName, "UserWorkspacesRoot");
        doc.setProperty("dublincore", "title", (Object)docName);
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        super.setUserWorkspaceRootACL(doc);
        return doc;
    }

    protected DocumentModel createUserWorkspace(CoreSession unrestrictedSession, PathRef wsRef, String userName) throws ClientException {
        String parentPath = new Path(wsRef.toString()).removeLastSegments(1).toString();
        String wsName = new Path(wsRef.toString()).lastSegment();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, wsName, super.getUserWorkspaceType());
        doc.setProperty("dublincore", "title", (Object)userName);
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        super.setUserWorkspaceACL(doc, userName);
        return doc;
    }

    protected DocumentModel getCurrentUserPersonalWorkspace(Principal principal, String userName, CoreSession userCoreSession, DocumentModel context) throws ClientException {
        PathRef uwref;
        if (principal == null && StringUtils.isEmpty((String)userName)) {
            return null;
        }
        String usedUsername = principal instanceof NuxeoPrincipal ? ((NuxeoPrincipal)principal).getActingUser() : userName;
        PathRef rootref = this.getExistingUserWorkspaceRoot(userCoreSession, usedUsername, context);
        if (rootref != null && (uwref = this.getExistingUserWorkspace(userCoreSession, rootref, principal, usedUsername)) != null) {
            DocumentModel uw = userCoreSession.getDocument((DocumentRef)uwref);
            return uw;
        }
        return null;
    }

    protected PathRef getExistingUserWorkspaceRoot(CoreSession session, String username, DocumentModel context) {
        PathRef rootref = new PathRef(this.computePathUserWorkspaceRoot(session, username, context));
        if (session.exists((DocumentRef)rootref)) {
            return rootref;
        }
        return null;
    }

    protected PathRef getExistingUserWorkspace(CoreSession session, PathRef rootref, Principal principal, String username) {
        String workspacename = this.getUserWorkspaceNameForUser(username);
        PathRef uwref = this.resolveUserWorkspace(session, rootref, username, workspacename, this.maxsize);
        if (session.exists((DocumentRef)uwref)) {
            return uwref;
        }
        PathRef uwcompatref = this.resolveUserWorkspace(session, rootref, username, IdUtils.generateId((String)username, (String)"-", (boolean)false, (int)30), 30);
        if (uwcompatref != null && session.exists((DocumentRef)uwcompatref)) {
            return uwcompatref;
        }
        return null;
    }

    public void asyncCreateUserWorkspace(CoreSession session, String username) {
        PathRef existingUserWorkspace;
        DocumentModel context = session.getRootDocument();
        PathRef rootref = this.getExistingUserWorkspaceRoot(session, username, context);
        if (rootref == null) {
            PathRef ref = new PathRef(this.computePathUserWorkspaceRoot(session, username, null));
            DocumentModel userWorkspaceRoot = this.doCreateUserWorkspacesRoot(session, ref);
            rootref = new PathRef(userWorkspaceRoot.getPathAsString());
        }
        if ((existingUserWorkspace = this.getExistingUserWorkspace(session, rootref, session.getPrincipal(), username)) == null) {
            Path computeUserWorspacePath = this.computeUserWorspacePath(rootref.value, username);
            PathRef uwPathRef = new PathRef(computeUserWorspacePath.toString());
            this.doCreateUserWorkspace(session, uwPathRef, session.getPrincipal(), username);
        }
    }
}

