/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.mapping.backward.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.Image;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.TextInput;
import yarfraw.generated.rss10.elements.Items;
import yarfraw.generated.rss10.elements.Li;
import yarfraw.generated.rss10.elements.RDF;
import yarfraw.generated.rss10.elements.Seq;
import yarfraw.generated.rss10.elements.TRss10Channel;
import yarfraw.generated.rss10.elements.TRss10Image;
import yarfraw.generated.rss10.elements.TRss10Item;
import yarfraw.generated.rss10.elements.TRss10TextInput;
import yarfraw.generated.rss10.elements.UpdatePeriodEnum;
import yarfraw.io.parser.ElementQName;
import yarfraw.mapping.backward.impl.Utils;
import yarfraw.utils.CommonUtils;
import yarfraw.utils.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Rss10MappingUtils {
    private static final Log LOG = LogFactory.getLog(Rss10MappingUtils.class);

    private Rss10MappingUtils() {
    }

    public static Integer calculateTtl(UpdatePeriodEnum updatePeriod, BigInteger updateFrequency) {
        return CommonUtils.calculateTtl(updatePeriod, updateFrequency);
    }

    public static ChannelFeed toChannel(TRss10Channel ch, RDF rdf) {
        ChannelFeed ret = new ChannelFeed();
        if (ch.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(ch.getOtherAttributes());
        }
        UpdatePeriodEnum updatePeriod = null;
        BigInteger updateFrequency = null;
        HashMap<String, Integer> ordering = new HashMap<String, Integer>();
        List<ItemEntry> items = Rss10MappingUtils.toItems(rdf.getChannelOrImageOrItem());
        ret.setAbout(ch.getAbout());
        ret.setResource(ch.getResource());
        ret.getOtherAttributes().putAll(ch.getOtherAttributes());
        for (Object o : ch.getTitleOrLinkOrDescription()) {
            if (o == null) continue;
            if (o instanceof JAXBElement) {
                JAXBElement jaxb = (JAXBElement)o;
                Object val = jaxb.getValue();
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_TITLE)) {
                    ret.setTitle((String)jaxb.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DESCRIPTION)) {
                    ret.setDescriptionOrSubtitle((String)jaxb.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_LINK)) {
                    ret.addLink((String)jaxb.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_UPDATEFREQUENCY)) {
                    updateFrequency = (BigInteger)jaxb.getValue();
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_SUBJECT)) {
                    ret.addCategorySubject(Utils.getDcTypeText(jaxb));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_PUBLISHER)) {
                    ret.addManagingEditorOrAuthorOrPublisher(Utils.getDcTypeText(jaxb));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_CREATOR)) {
                    ret.addWebMasterOrCreator(Utils.getDcTypeText(jaxb));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_RIGHTS)) {
                    ret.setRights(Utils.getDcTypeText(jaxb));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_DATE)) {
                    ret.setPubDate(Utils.getDcTypeText(jaxb));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_LANGUAGE)) {
                    ret.setLang(Utils.getDcTypeText(jaxb));
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_CONTRIBUTOR)) {
                    ret.addContributor(Utils.getDcTypeText(jaxb));
                    continue;
                }
                if (val instanceof UpdatePeriodEnum) {
                    updatePeriod = (UpdatePeriodEnum)((Object)val);
                    continue;
                }
                if (val instanceof TRss10Image) {
                    Image image = new Image();
                    image.setResource(((TRss10Image)val).getResource());
                    ret.setImageOrIcon(image);
                    continue;
                }
                if (val instanceof TRss10TextInput) {
                    TextInput in = new TextInput();
                    in.setResource(((TRss10TextInput)val).getResource());
                    ret.setTexInput(in);
                    continue;
                }
                if (val instanceof Items) {
                    Seq seq = ((Items)val).getSeq();
                    int i = 0;
                    for (Li li : seq.getLi()) {
                        ordering.put(li.getResource(), i++);
                    }
                    continue;
                }
                LOG.warn((Object)("Unexpected JAXBElement: " + ToStringBuilder.reflectionToString((Object)jaxb) + " this should not happen!"));
                continue;
            }
            if (o instanceof Element) {
                Element e = (Element)o;
                ret.getOtherElements().add(e);
                continue;
            }
            LOG.warn((Object)("Unexpected object: " + ToStringBuilder.reflectionToString((Object)o) + " this should not happen!"));
        }
        ret.setTtl(Rss10MappingUtils.calculateTtl(updatePeriod, updateFrequency));
        if (ordering.entrySet().size() != 0) {
            Collections.sort(items, new ItemComparacotr(ordering));
        }
        ret.setItems(items);
        return ret;
    }

    private static List<ItemEntry> toItems(List<Object> objs) {
        ArrayList<ItemEntry> items = new ArrayList<ItemEntry>();
        for (Object o : objs) {
            Object value;
            if (!(o instanceof JAXBElement) || !((value = ((JAXBElement)o).getValue()) instanceof TRss10Item)) continue;
            TRss10Item it = (TRss10Item)value;
            ItemEntry item = new ItemEntry();
            for (Object io : it.getTitleOrDescriptionOrLink()) {
                if (io instanceof JAXBElement) {
                    JAXBElement jaxb = (JAXBElement)io;
                    if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_TITLE)) {
                        item.setTitle((String)jaxb.getValue());
                        continue;
                    }
                    if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DESCRIPTION)) {
                        item.setDescriptionOrSummary((String)jaxb.getValue());
                        continue;
                    }
                    if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_LINK)) {
                        item.addLink((String)jaxb.getValue());
                        continue;
                    }
                    if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_CONTRIBUTOR)) {
                        item.addContributor(Utils.getDcTypeText(jaxb));
                        continue;
                    }
                    if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_CREATOR)) {
                        item.addAuthorOrCreator(Utils.getDcTypeText(jaxb));
                        continue;
                    }
                    if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_RIGHTS)) {
                        item.setRights(Utils.getDcTypeText(jaxb));
                        continue;
                    }
                    if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_DATE)) {
                        item.setPubDate(Utils.getDcTypeText(jaxb));
                        continue;
                    }
                    if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DC_SUBJECT)) {
                        item.addCategorySubject(Utils.getDcTypeText(jaxb));
                        continue;
                    }
                    LOG.warn((Object)("Unexpected jaxbElement under <item>: " + ToStringBuilder.reflectionToString((Object)jaxb)));
                    continue;
                }
                if (io instanceof Element) {
                    Element e = (Element)io;
                    item.getOtherElements().add(e);
                    continue;
                }
                LOG.warn((Object)("Unexpected object under <item>: " + ToStringBuilder.reflectionToString((Object)io)));
            }
            if (it.getResource() == null) {
                it.setResource(Utils.getHrefLink(item.getLinks()));
            }
            items.add(item);
        }
        return items;
    }

    public static TextInput populateTextinput(TextInput ret, TRss10TextInput input) {
        for (Object o : input.getTitleOrDescriptionOrName()) {
            if (o == null) continue;
            if (o instanceof JAXBElement) {
                JAXBElement jaxb = (JAXBElement)o;
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_TITLE)) {
                    ret.setTitle((String)jaxb.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_DESCRIPTION)) {
                    ret.setDescription((String)jaxb.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_LINK)) {
                    ret.setLink((String)jaxb.getValue());
                    continue;
                }
                if (XMLUtils.same(jaxb.getName(), ElementQName.RSS10_NAME)) {
                    ret.setName((String)jaxb.getValue());
                    continue;
                }
                LOG.warn((Object)("Unexpected JAXBElement: " + ToStringBuilder.reflectionToString((Object)jaxb) + " this should not happen!"));
                continue;
            }
            if (o instanceof Element) {
                Element e = (Element)o;
                ret.getOtherElements().add(e);
                continue;
            }
            LOG.warn((Object)("Unexpected object: " + ToStringBuilder.reflectionToString((Object)o) + " this should not happen!"));
        }
        ret.setAbout(input.getAbout());
        return ret;
    }

    public static Image populateImage(Image ret, TRss10Image img) {
        ret.setLink(img.getLink());
        ret.setTitle(img.getTitle());
        ret.setUrl(img.getUrl());
        ret.setAbout(img.getAbout());
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ItemComparacotr
    implements Comparator<ItemEntry> {
        Map<String, Integer> _ordering = null;

        public ItemComparacotr(Map<String, Integer> ordering) {
            this._ordering = ordering;
        }

        @Override
        public int compare(ItemEntry o1, ItemEntry o2) {
            Integer ord1 = this._ordering.get(o1.getAbout());
            Integer ord2 = this._ordering.get(o2.getAbout());
            return ord1 != null && ord2 != null ? ord1.compareTo(ord2) : 0;
        }
    }
}

