/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.rest;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.model.Validator;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.runtime.api.Framework;

public class DocumentHelper {
    private DocumentHelper() {
    }

    public static DocumentModel createDocument(WebContext context, DocumentModel parent, String name) {
        try {
            Module module;
            Validator v;
            PathSegmentService pss;
            try {
                pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
            CoreSession session = context.getCoreSession();
            FormData form = context.getForm();
            String type = form.getDocumentType();
            if (type == null) {
                throw new WebException("Invalid argument exception. Nos doc type specified");
            }
            DocumentModel newDoc = session.createDocumentModel(type);
            form.fillDocument(newDoc);
            if (name != null) {
                newDoc.setPropertyValue("dc:title", (Serializable)((Object)name));
            }
            if ((v = (module = context.getModule()).getValidator(newDoc.getType())) != null) {
                newDoc = v.validate(newDoc);
            }
            newDoc.setPathInfo(parent.getPathAsString(), pss.generatePathSegment(newDoc));
            newDoc = session.createDocument(newDoc);
            newDoc.setPropertyValue("dc:title", (Serializable)((Object)newDoc.getName()));
            session.saveDocument(newDoc);
            session.save();
            return newDoc;
        }
        catch (Exception e) {
            throw WebException.wrap((String)("Failed to create document: " + name), (Throwable)e);
        }
    }

    public static DocumentModel updateDocument(WebContext ctx, DocumentModel doc) {
        try {
            FormData form = ctx.getForm();
            form.fillDocument(doc);
            doc.putContextData("VersioningOption", (Serializable)form.getVersioningOption());
            Module module = ctx.getModule();
            Validator v = module.getValidator(doc.getType());
            if (v != null) {
                doc = v.validate(doc);
            }
            doc = ctx.getCoreSession().saveDocument(doc);
            ctx.getCoreSession().save();
            return doc;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to update document", (Throwable)e);
        }
    }
}

