/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModEngine;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModQueryOut;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.QueryCheckException;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.util.QueryOutputUtils;
import com.hp.hpl.jena.sparql.util.QueryUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.PrintStream;
import java.util.Iterator;

public class qparse
extends CmdARQ {
    ModQueryIn modQuery = new ModQueryIn();
    ModQueryOut modOutput = new ModQueryOut();
    ModEngine modEngine = new ModEngine();
    protected final ArgDecl argDeclPrint = new ArgDecl(true, "print");
    protected final ArgDecl argDeclOpt = new ArgDecl(false, "opt", "optimize");
    protected final ArgDecl argDeclExplain = new ArgDecl(false, "explain");
    boolean printQuery = false;
    boolean printOp = false;
    boolean printOpt = false;
    boolean printQuad = false;
    boolean printQuadOpt = false;
    boolean printPlan = false;
    static String usage = qparse.class.getName() + " [--in syntax] [--out syntax] [--print=FORM] [\"query\"] | --query <file>";
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String ... argv) {
        new qparse(argv).mainRun();
    }

    public qparse(String[] argv) {
        super(argv);
        super.addModule(this.modQuery);
        super.addModule(this.modOutput);
        super.addModule(this.modEngine);
        super.getUsage().startCategory(null);
        super.add(this.argDeclPrint, "--print", "Print in various forms [query, op, quad, plan]");
        super.add(this.argDeclExplain, "--explain", "Print with algebra-level optimization");
        super.add(this.argDeclOpt, "--opt", "[deprecated]");
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(this.argDeclOpt)) {
            this.printOpt = true;
        }
        if (this.contains(this.argDeclExplain)) {
            this.printQuery = true;
            this.printOpt = true;
        }
        for (String arg : this.getValues(this.argDeclPrint)) {
            if (arg.equalsIgnoreCase("query")) {
                this.printQuery = true;
                continue;
            }
            if (arg.equalsIgnoreCase("op") || arg.equalsIgnoreCase("alg") || arg.equalsIgnoreCase("algebra")) {
                this.printOp = true;
                continue;
            }
            if (arg.equalsIgnoreCase("quad")) {
                this.printQuad = true;
                continue;
            }
            if (arg.equalsIgnoreCase("quads")) {
                this.printQuad = true;
                continue;
            }
            if (arg.equalsIgnoreCase("plan")) {
                this.printPlan = true;
                continue;
            }
            if (arg.equalsIgnoreCase("opt")) {
                this.printOpt = true;
                continue;
            }
            if (arg.equalsIgnoreCase("optquad")) {
                this.printQuadOpt = true;
                continue;
            }
            if (arg.equalsIgnoreCase("quadopt")) {
                this.printQuadOpt = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: query, op, quad, opt, optquad");
        }
        if (!(this.printQuery || this.printOp || this.printQuad || this.printPlan || this.printOpt || this.printQuadOpt)) {
            this.printQuery = true;
        }
    }

    protected String getSummary() {
        return usage;
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    protected void exec() {
        try {
            Query query2;
            block16: {
                query2 = this.modQuery.getQuery();
                try {
                    QueryUtils.checkQuery(query2, true);
                }
                catch (QueryCheckException ex) {
                    System.err.println();
                    System.err.println("**** Check failure: " + ex.getMessage());
                    if (ex.getCause() == null) break block16;
                    ex.getCause().printStackTrace(System.err);
                }
            }
            if (this.printQuery) {
                this.divider();
                this.modOutput.output(query2);
            }
            if (this.printOp) {
                this.divider();
                this.modOutput.outputOp(query2, false);
            }
            if (this.printQuad) {
                this.divider();
                this.modOutput.outputQuad(query2, false);
            }
            if (this.printOpt) {
                this.divider();
                this.modOutput.outputOp(query2, true);
            }
            if (this.printQuadOpt) {
                this.divider();
                this.modOutput.outputQuad(query2, true);
            }
            if (this.printPlan) {
                this.divider();
                QueryExecution qExec = QueryExecutionFactory.create(query2, (Dataset)DatasetFactory.create());
                QueryOutputUtils.printPlan(query2, qExec);
            }
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
        }
        catch (ResultSetException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        catch (QueryException qEx) {
            throw new CmdException("Query Exeception", (Throwable)((Object)qEx));
        }
        catch (JenaException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (CmdException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Exception", ex);
        }
    }

    protected String getCommandName() {
        return Utils.className(this);
    }

    static void writeSyntaxes(String msg, PrintStream out) {
        if (msg != null) {
            out.println(msg);
        }
        Iterator<String> iter = Syntax.querySyntaxNames.keys();
        while (iter.hasNext()) {
            String k = iter.next();
            Syntax v = Syntax.lookup(k);
            k = qparse.padOut(k, 10);
            out.println("  " + k + "  " + v);
        }
    }

    static String padOut(String x, int len) {
        StringBuffer r = new StringBuffer(x);
        for (int i = x.length(); i <= len; ++i) {
            r.append(" ");
        }
        return r.toString();
    }
}

