/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.operation;

import fr.toutatice.ecm.acrennes.publishing.AcrennesPublishedDocumentWithWorkflowFactory;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.helper.ToutaticePublishHelper;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublisherService;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.RemotePublishDocument", category="Document", label="Simple remote publication", description="Publish the input document into the first target section find. Existing proxy is overrided if the override attribute is set. Return the created proxy.")
public class RemotePublishDocument {
    public static final String ID = "Document.RemotePublishDocument";
    private static final Log log = LogFactory.getLog(RemotePublishDocument.class);
    @Context
    protected CoreSession session;
    @Param(name="transition", required=false)
    protected String transition;
    @Param(name="override", required=false, values={"true"})
    protected boolean override = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        DocumentModel target = null;
        PublishedDocument publishedDocument = null;
        PublisherService ps = (PublisherService)Framework.getLocalService(PublisherService.class);
        target = ToutaticePublishHelper.getFirstSection(doc, ps, this.session);
        DocumentRef targetRef = target.getRef();
        DocumentRef baseDocRef = doc.getRef();
        DocumentModel proxy = null;
        if (!doc.isVersion()) {
            log.debug((Object)"document en projet le pass\u00e9 \u00e0 l'\u00e9tat valid\u00e9 ");
            if (StringUtils.isBlank((String)this.transition)) {
                throw new ClientException("Veuillez valider votre document ");
            }
            if ("project".equals(doc.getCurrentLifeCycleState())) {
                doc.setPropertyValue("dc:valid", (Serializable)new Date());
                this.session.saveDocument(doc);
                this.session.followTransition(doc.getRef(), this.transition);
                doc.refresh(1, null);
            }
            if (!doc.isCheckedOut()) {
                String label = doc.getVersionLabel();
                VersionModelImpl vm = new VersionModelImpl();
                vm.setLabel(label);
                DocumentModel vdoc = this.session.getDocumentWithVersion(doc.getRef(), (VersionModel)vm);
                if (null != vdoc && "project".equals(vdoc.getCurrentLifeCycleState())) {
                    this.session.followTransition(vdoc.getRef(), this.transition);
                }
            }
        }
        if (null != targetRef) {
            log.debug((Object)"debut de publication ");
            if (doc.isVersion()) {
                String sourceDocId = doc.getSourceId();
                baseDocRef = new IdRef(sourceDocId);
            }
        } else {
            throw new ClientException("Failed to get the target document reference");
        }
        publishedDocument = AcrennesPublishedDocumentWithWorkflowFactory.getInstance().publish(this.session, doc, target);
        SilentRenameProxy runner = new SilentRenameProxy(this.session, doc, publishedDocument, target);
        runner.silentRun(true);
        proxy = runner.getProxy();
        log.debug((Object)"fin de publication ");
        return proxy;
    }

    private class SilentRenameProxy
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel doc;
        private DocumentModel newProxy;
        private DocumentModel target;
        private PublishedDocument publishedDocument;

        public DocumentModel getProxy() {
            return this.newProxy;
        }

        public SilentRenameProxy(CoreSession session, DocumentModel doc, PublishedDocument publishedDocument, DocumentModel target) {
            super(session);
            this.doc = doc;
            this.target = target;
            this.publishedDocument = publishedDocument;
        }

        public void run() throws ClientException {
            this.newProxy = null;
            String newProxyName = null;
            if (this.publishedDocument.isPending()) {
                newProxyName = this.doc.getName() + ".pending";
            }
            this.newProxy = ((SimpleCorePublishedDocument)this.publishedDocument).getProxy();
            if (!this.newProxy.getName().equals(newProxyName)) {
                this.session.move(this.newProxy.getRef(), this.target.getRef(), newProxyName);
            }
        }
    }
}

