/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication.finder;

import fr.toutatice.ecm.platform.web.publication.finder.ToutaticeRootSectionsFinder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public class ToutaticeRemoteRootSectionsFinder
extends ToutaticeRootSectionsFinder {
    private static final Log log = LogFactory.getLog(ToutaticeRemoteRootSectionsFinder.class);
    protected List<String> unrestrictedSectionRootFromLocalConfig;
    protected DocumentModel unrestrictedSectionRootParentCfgOwner;

    public ToutaticeRemoteRootSectionsFinder(CoreSession userSession) {
        super(userSession);
    }

    protected DocumentModelList getFiltredSectionRoots(List<String> rootPaths, boolean onlyHeads) throws ClientException {
        ArrayList<Object> filtredDocRef = new ArrayList<Object>();
        ArrayList<DocumentRef> trashedDocRef = new ArrayList<DocumentRef>();
        for (String rootPath : rootPaths) {
            try {
                PathRef rootRef = new PathRef(rootPath);
                if (this.userSession.hasPermission((DocumentRef)rootRef, "Read")) {
                    filtredDocRef.add(rootRef);
                    continue;
                }
                DocumentModelList accessibleSections = this.userSession.query(this.buildQuery(rootPath.replace("'", "\\'")));
                for (DocumentModel section : accessibleSections) {
                    if (onlyHeads && (filtredDocRef.contains(section.getParentRef()) || trashedDocRef.contains(section.getParentRef()))) {
                        trashedDocRef.add(section.getRef());
                        continue;
                    }
                    filtredDocRef.add(section.getRef());
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to get the section root '" + rootPath + "', error: " + e.getMessage()));
            }
        }
        DocumentModelList documents = this.userSession.getDocuments(filtredDocRef.toArray(new DocumentRef[filtredDocRef.size()]));
        return this.filterDocuments(documents);
    }

    protected void computeUnrestrictedRoots(CoreSession session) throws ClientException {
        if (this.currentDocument != null) {
            this.unrestrictedSectionRootParentCfgOwner = this.getPublishingParent(session, this.currentDocument);
            this.unrestrictedSectionRootFromWorkspaceConfig = new ArrayList();
            if (this.unrestrictedSectionRootParentCfgOwner != null) {
                DocumentModelList sectionRootsFromWorkspaceConfig = this.getSectionRootsFromWorkspaceConfig(this.unrestrictedSectionRootParentCfgOwner, session);
                for (DocumentModel root : sectionRootsFromWorkspaceConfig) {
                    this.unrestrictedSectionRootFromWorkspaceConfig.add(root.getPathAsString());
                }
            }
        }
        if (this.unrestrictedDefaultSectionRoot == null) {
            this.unrestrictedDefaultSectionRoot = Collections.emptyList();
        }
    }

    protected void computeUnrestrictedLocalRoots(CoreSession session) throws ClientException {
        if (this.currentDocument != null) {
            DocumentModelList sectionRootsFromWorkspaceConfig = this.getSectionRootsFromWorkspaceConfig(this.currentDocument, session);
            this.unrestrictedSectionRootFromLocalConfig = new ArrayList<String>();
            for (DocumentModel root : sectionRootsFromWorkspaceConfig) {
                this.unrestrictedSectionRootFromLocalConfig.add(root.getPathAsString());
            }
            if (log.isDebugEnabled() && this.unrestrictedSectionRootFromLocalConfig != null) {
                log.debug((Object)("#computeUnrestrictedLocalRoots | unrestrictedSectionRootFromLocalConfig: " + StringUtils.join(this.unrestrictedSectionRootFromLocalConfig, (String)", ")));
            }
        }
    }

    public DocumentModelList getSectionRootsForWorkspace(DocumentModel currentDoc, boolean addDefaultSectionRoots) throws ClientException {
        return this.getSectionRootsForWorkspace(currentDoc, addDefaultSectionRoots, ROOT_SECTION_TYPE.ALL);
    }

    public DocumentModelList getSectionRootsForWorkspace(DocumentModel currentDoc, boolean addDefaultSectionRoots, ROOT_SECTION_TYPE sectionListType) throws ClientException {
        if (this.currentDocument == null || !this.currentDocument.getRef().equals(currentDoc.getRef())) {
            this.computeUserSectionRoots(currentDoc);
        }
        if (this.unrestrictedDefaultSectionRoot == null || this.unrestrictedDefaultSectionRoot.isEmpty()) {
            DocumentModelList defaultSectionRoots = this.getDefaultSectionRoots(this.session);
            this.unrestrictedDefaultSectionRoot = new ArrayList();
            for (DocumentModel root : defaultSectionRoots) {
                this.unrestrictedDefaultSectionRoot.add(root.getPathAsString());
            }
        }
        ArrayList<String> agregatedList = new ArrayList<String>();
        if (ROOT_SECTION_TYPE.ALL.equals((Object)sectionListType) || ROOT_SECTION_TYPE.HERITED.equals((Object)sectionListType)) {
            agregatedList.addAll(this.unrestrictedSectionRootFromWorkspaceConfig);
        }
        if (ROOT_SECTION_TYPE.ALL.equals((Object)sectionListType) || ROOT_SECTION_TYPE.LOCAL.equals((Object)sectionListType)) {
            agregatedList.addAll(this.unrestrictedSectionRootFromLocalConfig);
        }
        return this.getFiltredSectionRoots(agregatedList, true);
    }

    public DocumentModelList getSectionRootsForLocal(DocumentModel currentDoc, boolean addDefaultSectionRoots) throws ClientException {
        if (this.currentDocument == null || !this.currentDocument.getRef().equals(currentDoc.getRef())) {
            this.computeUserSectionRoots(currentDoc);
        }
        return this.getFiltredSectionRoots(this.unrestrictedSectionRootFromLocalConfig, true);
    }

    public DocumentModel getParentCfgOwner() {
        return this.unrestrictedSectionRootParentCfgOwner;
    }

    private DocumentModel getPublishingParent(CoreSession session, DocumentModel document) throws ClientException {
        DocumentModel publishingParent = null;
        DocumentModel parentDocument = document;
        while (!this.hasConfiguredSections(parentDocument) && !"Root".equals(parentDocument.getType())) {
            parentDocument = session.getDocument(parentDocument.getParentRef());
        }
        if (!"Root".equals(parentDocument.getType())) {
            publishingParent = parentDocument;
        }
        return publishingParent;
    }

    private boolean hasConfiguredSections(DocumentModel document) {
        boolean has = false;
        if (document != null && document.hasSchema("publishing")) {
            String[] sectionIdsArray = (String[])document.getPropertyValue("publish:sections");
            has = sectionIdsArray != null && sectionIdsArray.length > 0;
        }
        return has;
    }

    public void run() throws ClientException {
        this.computeUnrestrictedRoots(this.session);
        this.computeUnrestrictedLocalRoots(this.session);
    }

    public static enum ROOT_SECTION_TYPE {
        LOCAL,
        HERITED,
        ALL;

    }
}

