/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication.validation;

import fr.toutatice.ecm.platform.web.workflows.ToutaticeDocumentRoutingActionsBean;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.task.Task;

@Name(value="routingActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=51)
public class ToutaticeRPDocumentRoutingActionsBean
extends ToutaticeDocumentRoutingActionsBean {
    private static final long serialVersionUID = 8176244997123301627L;
    private static final Log log = LogFactory.getLog(ToutaticeRPDocumentRoutingActionsBean.class);

    public String startValidationWorkflow() throws ClientException {
        String res = null;
        DocumentModel validationWf = this.getValidationWorkflowModel();
        res = this.startWorkflow(validationWf, "toutatice.label.validation.wf.started");
        this.notifyTaskActors(this.navigationContext.getCurrentDocument(), "validate-validation", "workflowReviewTaskAssigned");
        return res;
    }

    private DocumentModel getValidationWorkflowModel() throws ClientException {
        String id = this.getDocumentRoutingService().getRouteModelDocIdWithId(this.documentManager, "toutatice_validation");
        return this.getRouteModel(id);
    }

    public String cancelValidationWorkflow() throws ClientException {
        return super.cancelWorkflow("toutatice_validation", "workflowReviewTaskCanceled");
    }

    public boolean isCancelValidationActionAuthorized() throws ClientException {
        boolean doWorkflowExist = false;
        boolean isUserInitiator = false;
        try {
            doWorkflowExist = this.isValidationWorkflowRunning();
            NuxeoPrincipal principal = this.currentUser;
            isUserInitiator = principal.getName().equals(this.getCurrentWorkflowInitiator());
        }
        catch (Exception e) {
            log.debug((Object)("Failed to execute 'isCancelValidationActionAuthorized()', error: " + e.getMessage()));
        }
        return doWorkflowExist && isUserInitiator;
    }

    public boolean isValidationWorkflowRunning() {
        return this.getValidationWorkflow() != null;
    }

    public DocumentRoute getValidationWorkflow() {
        List routes = this.getRelatedRoutes();
        return this.getRunningWorkflowByName(routes, "toutatice_validation");
    }

    public Task getValidateTask(String wfName) throws ClientException {
        Task validate = null;
        String taskName = "";
        if ("toutatice_online_approbation".equals(wfName)) {
            taskName = "validate-online";
        } else if ("toutatice_validation".equals(wfName)) {
            taskName = "validate-validation";
        }
        if (StringUtils.isNotBlank((String)taskName)) {
            List currentRouteAllTasks = this.getCurrentRouteAllTasks();
            Iterator iterator = currentRouteAllTasks.iterator();
            while (iterator.hasNext() && validate == null) {
                Task task = (Task)iterator.next();
                if (!taskName.equalsIgnoreCase(task.getName())) continue;
                validate = task;
            }
        }
        return validate;
    }
}

