/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.control.SourceUnit;

public class VariableScopeVisitor
extends ClassCodeVisitorSupport {
    private VariableScope currentScope = null;
    private VariableScope headScope = new VariableScope();
    private ClassNode currentClass = null;
    private SourceUnit source;
    private boolean inClosure = false;
    private boolean inPropertyExpression = false;
    private boolean isSpecialConstructorCall = false;
    private LinkedList stateStack = new LinkedList();

    public VariableScopeVisitor(SourceUnit source) {
        this.source = source;
        this.currentScope = this.headScope;
    }

    private void pushState(boolean isStatic) {
        this.stateStack.add(new StateStackElement());
        this.currentScope = new VariableScope(this.currentScope);
        this.currentScope.setInStaticContext(isStatic);
    }

    private void pushState() {
        this.pushState(this.currentScope.isInStaticContext());
    }

    private void popState() {
        if (this.inClosure) {
            this.currentScope.setInStaticContext(false);
        }
        StateStackElement element = (StateStackElement)this.stateStack.removeLast();
        this.currentScope = element.scope;
        this.currentClass = element.clazz;
        this.inClosure = element.closure;
    }

    private void declare(Parameter[] parameters, ASTNode node) {
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].hasInitialExpression()) {
                parameters[i].getInitialExpression().visit(this);
            }
            this.declare(parameters[i], node);
        }
    }

    private void declare(VariableExpression expr) {
        this.declare(expr, (ASTNode)expr);
    }

    private void declare(Variable var, ASTNode expr) {
        String scopeType = "scope";
        String variableType = "variable";
        if (expr.getClass() == FieldNode.class) {
            scopeType = "class";
            variableType = "field";
        } else if (expr.getClass() == PropertyNode.class) {
            scopeType = "class";
            variableType = "property";
        }
        StringBuffer msg = new StringBuffer();
        msg.append("The current ").append(scopeType);
        msg.append(" already contains a ").append(variableType);
        msg.append(" of the name ").append(var.getName());
        if (this.currentScope.getDeclaredVariable(var.getName()) != null) {
            this.addError(msg.toString(), expr);
            return;
        }
        for (VariableScope scope = this.currentScope.getParent(); scope != null && scope.getClassScope() == null; scope = scope.getParent()) {
            if (scope.getDeclaredVariable(var.getName()) == null) continue;
            this.addError(msg.toString(), expr);
            break;
        }
        this.currentScope.putDeclaredVariable(var);
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private Variable findClassMember(ClassNode cn, String name) {
        AnnotatedNode f;
        if (cn == null) {
            return null;
        }
        if (cn.isScript()) {
            return new DynamicVariable(name, false);
        }
        List l = cn.getFields();
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            f = (FieldNode)iter.next();
            if (!((FieldNode)f).getName().equals(name)) continue;
            return f;
        }
        l = cn.getMethods();
        iter = l.iterator();
        while (iter.hasNext()) {
            f = (MethodNode)iter.next();
            String methodName = ((MethodNode)f).getName();
            String pName = this.getPropertyName((MethodNode)f);
            if (pName == null || !pName.equals(name)) continue;
            PropertyNode var = new PropertyNode(pName, ((MethodNode)f).getModifiers(), this.getPropertyType((MethodNode)f), cn, null, null, null);
            return var;
        }
        l = cn.getProperties();
        iter = l.iterator();
        while (iter.hasNext()) {
            f = (PropertyNode)iter.next();
            if (!((PropertyNode)f).getName().equals(name)) continue;
            return f;
        }
        Variable ret = this.findClassMember(cn.getSuperClass(), name);
        if (ret != null) {
            return ret;
        }
        return this.findClassMember(cn.getOuterClass(), name);
    }

    private ClassNode getPropertyType(MethodNode m) {
        String name = m.getName();
        if (m.getReturnType() != ClassHelper.VOID_TYPE) {
            return m.getReturnType();
        }
        return m.getParameters()[0].getType();
    }

    private String getPropertyName(MethodNode m) {
        String name = m.getName();
        if (!name.startsWith("set") && !name.startsWith("get")) {
            return null;
        }
        String pname = name.substring(3);
        if (pname.length() == 0) {
            return null;
        }
        String s = pname.substring(0, 1).toLowerCase();
        String rest = pname.substring(1);
        pname = s + rest;
        if (name.startsWith("get") && m.getReturnType() == ClassHelper.VOID_TYPE) {
            return null;
        }
        if (name.startsWith("set") && m.getParameters().length != 1) {
            return null;
        }
        return pname;
    }

    private Variable checkVariableNameForDeclaration(String name, Expression expression) {
        if ("super".equals(name) || "this".equals(name)) {
            return null;
        }
        VariableScope scope = this.currentScope;
        Variable var = new DynamicVariable(name, this.currentScope.isInStaticContext());
        DynamicVariable dummyStart = var;
        VariableScope dynamicScope = null;
        while (!scope.isRoot()) {
            Variable var1;
            if (dynamicScope == null && scope.isResolvingDynamic()) {
                dynamicScope = scope;
            }
            if ((var1 = scope.getDeclaredVariable(var.getName())) != null) {
                var = var1;
                break;
            }
            var1 = scope.getReferencedLocalVariable(var.getName());
            if (var1 != null) {
                var = var1;
                break;
            }
            var1 = scope.getReferencedClassVariable(var.getName());
            if (var1 != null) {
                var = var1;
                break;
            }
            ClassNode classScope = scope.getClassScope();
            if (classScope != null) {
                Variable member = this.findClassMember(classScope, var.getName());
                if (member == null) break;
                boolean cc = this.currentScope.isInStaticContext() || this.isSpecialConstructorCall;
                boolean cm = member.isInStaticContext();
                if (!cm && cm != cc) break;
                var = member;
                break;
            }
            scope = scope.getParent();
        }
        VariableScope end = scope;
        if (scope.isRoot() && dynamicScope == null) {
            this.declare(var, (ASTNode)expression);
            this.addError("The variable " + var.getName() + " is undefined in the current scope", expression);
        } else if (scope.isRoot() && dynamicScope != null) {
            scope = dynamicScope;
        }
        if (!scope.isRoot()) {
            for (scope = this.currentScope; scope != end; scope = scope.getParent()) {
                Object references = null;
                if (end.isClassScope() || end.isRoot() || end.isReferencedClassVariable(name) && end.getDeclaredVariable(name) == null) {
                    scope.putReferencedClassVariable(var);
                    continue;
                }
                var.setClosureSharedVariable(var.isClosureSharedVariable() || this.inClosure);
                scope.putReferencedLocalVariable(var);
            }
            if (end.isResolvingDynamic() && end.getDeclaredVariable(var.getName()) == null) {
                end.putDeclaredVariable(var);
            }
        }
        return var;
    }

    private void checkPropertyOnExplicitThis(PropertyExpression pe) {
        if (!this.currentScope.isInStaticContext()) {
            return;
        }
        Expression object = pe.getObjectExpression();
        if (!(object instanceof VariableExpression)) {
            return;
        }
        VariableExpression ve = (VariableExpression)object;
        if (!ve.getName().equals("this")) {
            return;
        }
        String name = pe.getPropertyAsString();
        if (name == null) {
            return;
        }
        Variable member = this.findClassMember(this.currentClass, name);
        if (member == null) {
            return;
        }
        this.checkVariableContextAccess(member, pe);
    }

    private void checkVariableContextAccess(Variable v, Expression expr) {
        if (this.inPropertyExpression || v.isInStaticContext() || !this.currentScope.isInStaticContext()) {
            return;
        }
        String msg = v.getName() + " is declared in a dynamic context, but you tried to" + " access it from a static context.";
        this.addError(msg, expr);
        DynamicVariable v2 = new DynamicVariable(v.getName(), this.currentScope.isInStaticContext());
        this.currentScope.putDeclaredVariable(v2);
    }

    public void visitBlockStatement(BlockStatement block) {
        this.pushState();
        block.setVariableScope(this.currentScope);
        super.visitBlockStatement(block);
        this.popState();
    }

    public void visitForLoop(ForStatement forLoop) {
        this.pushState();
        forLoop.setVariableScope(this.currentScope);
        Parameter p = forLoop.getVariable();
        p.setInStaticContext(this.currentScope.isInStaticContext());
        if (p != ForStatement.FOR_LOOP_DUMMY) {
            this.declare(p, (ASTNode)forLoop);
        }
        super.visitForLoop(forLoop);
        this.popState();
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        expression.getRightExpression().visit(this);
        VariableExpression vex = expression.getVariableExpression();
        vex.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(vex);
        vex.setAccessedVariable(vex);
    }

    public void visitVariableExpression(VariableExpression expression) {
        String name = expression.getName();
        Variable v = this.checkVariableNameForDeclaration(name, expression);
        if (v == null) {
            return;
        }
        expression.setAccessedVariable(v);
        this.checkVariableContextAccess(v, expression);
    }

    public void visitPropertyExpression(PropertyExpression expression) {
        boolean ipe = this.inPropertyExpression;
        this.inPropertyExpression = true;
        expression.getObjectExpression().visit(this);
        this.inPropertyExpression = false;
        expression.getProperty().visit(this);
        this.checkPropertyOnExplicitThis(expression);
        this.inPropertyExpression = ipe;
    }

    public void visitClosureExpression(ClosureExpression expression) {
        this.pushState();
        this.inClosure = true;
        this.currentScope.setDynamicResolving(true);
        expression.setVariableScope(this.currentScope);
        if (expression.isParameterSpecified()) {
            Parameter[] parameters = expression.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i].setInStaticContext(this.currentScope.isInStaticContext());
                if (parameters[i].hasInitialExpression()) {
                    parameters[i].getInitialExpression().visit(this);
                }
                this.declare(parameters[i], (ASTNode)expression);
            }
        } else if (expression.getParameters() != null) {
            DynamicVariable var = new DynamicVariable("it", this.currentScope.isInStaticContext());
            this.currentScope.putDeclaredVariable(var);
        }
        super.visitClosureExpression(expression);
        this.popState();
    }

    public void visitCatchStatement(CatchStatement statement) {
        this.pushState();
        Parameter p = statement.getVariable();
        p.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(p, (ASTNode)statement);
        super.visitCatchStatement(statement);
        this.popState();
    }

    public void visitFieldExpression(FieldExpression expression) {
        String name = expression.getFieldName();
        Variable v = this.checkVariableNameForDeclaration(name, expression);
        this.checkVariableContextAccess(v, expression);
    }

    public void visitClass(ClassNode node) {
        this.pushState();
        this.currentClass = node;
        boolean dynamicMode = node.isScript();
        this.currentScope.setDynamicResolving(dynamicMode);
        this.currentScope.setClassScope(node);
        super.visitClass(node);
        this.popState();
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.pushState(node.isStatic());
        node.setVariableScope(this.currentScope);
        Parameter[] parameters = node.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            this.visitAnnotations(parameter);
        }
        this.declare(node.getParameters(), (ASTNode)node);
        super.visitConstructorOrMethod(node, isConstructor);
        this.popState();
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        if (call.isImplicitThis() && call.getMethod() instanceof ConstantExpression) {
            String value = ((ConstantExpression)call.getMethod()).getText();
            if (!(value instanceof String)) {
                throw new GroovyBugError("tried to make a method call with a non-String constant method name.");
            }
            String methodName = value;
            Variable v = this.checkVariableNameForDeclaration(methodName, call);
            if (v != null && !(v instanceof DynamicVariable)) {
                this.checkVariableContextAccess(v, call);
            }
        }
        super.visitMethodCallExpression(call);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        this.isSpecialConstructorCall = call.isSpecialCall();
        super.visitConstructorCallExpression(call);
        this.isSpecialConstructorCall = false;
    }

    public void visitProperty(PropertyNode node) {
        this.pushState(node.isStatic());
        super.visitProperty(node);
        this.popState();
    }

    public void visitField(FieldNode node) {
        this.pushState(node.isStatic());
        super.visitField(node);
        this.popState();
    }

    private class StateStackElement {
        VariableScope scope;
        ClassNode clazz;
        boolean closure;

        StateStackElement() {
            this.scope = VariableScopeVisitor.this.currentScope;
            this.clazz = VariableScopeVisitor.this.currentClass;
            this.closure = VariableScopeVisitor.this.inClosure;
        }
    }
}

