/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.dco.ecm.validator;

import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="acarenDcoValidatorBean")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class AcarenDcoValidatorBean
implements Serializable {
    private static final long serialVersionUID = 4323506213976393458L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    private static final Log log = LogFactory.getLog(AcarenDcoValidatorBean.class);

    public void validateFile(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        InputFileInfo fileInfo = (InputFileInfo)value;
        String nameFile = (String)fileInfo.getFilename();
        try {
            Pattern p;
            Matcher m;
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            if (!"DCODepotConfidentiel".equals(currentDoc.getType())) {
                DocumentRef parentRef = currentDoc.getParentRef();
                currentDoc = this.documentManager.getDocument(parentRef);
            }
            UnrestrictedGetNbSameDocsRunner runner = new UnrestrictedGetNbSameDocsRunner(this.documentManager, currentDoc, nameFile);
            runner.runUnrestricted();
            int nbDoc = runner.getCount();
            if (nbDoc != 0) {
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.dco.unique", (Object[])new Object[]{nameFile}), null);
                throw new ValidatorException(message);
            }
            Map attributes = component.getAttributes();
            String namePattern = (String)attributes.get("formatName");
            Property ppt = currentDoc.getProperty("dco:validator");
            String detail = (String)((Object)ppt.get("msgerrorregex").getValue());
            if (!StringUtils.isBlank((String)namePattern) && !(m = (p = Pattern.compile(namePattern)).matcher(nameFile)).matches()) {
                if (StringUtils.isBlank((String)detail)) {
                    detail = namePattern;
                }
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.dco.error.name.format", (Object[])new Object[]{detail}), null);
                throw new ValidatorException(message);
            }
        }
        catch (PatternSyntaxException pse) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.dco.error.patternException"), null);
            throw new ValidatorException(message);
        }
        catch (ClientException e) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.acaren.validator.dco.error.technique"), null);
            throw new ValidatorException(message);
        }
    }

    private static class UnrestrictedGetNbSameDocsRunner
    extends UnrestrictedSessionRunner {
        private int count = 0;
        private String nameFile;
        private DocumentModel document;

        public int getCount() {
            return this.count;
        }

        protected UnrestrictedGetNbSameDocsRunner(CoreSession session, DocumentModel document, String nameFile) {
            super(session);
            this.nameFile = nameFile;
            this.document = document;
        }

        public void run() throws ClientException {
            DocumentModelList rs = this.session.query("SELECT * FROM DCOFichierConfidentiel WHERE ecm:parentId = '" + this.document.getId() + "' AND ecm:mixinType != 'HiddenInNavigation' AND ecm:currentLifeCycleState !='deleted'AND ecm:isCheckedInVersion = 0 AND dc:title = '" + this.nameFile + "'", null);
            this.count = rs.size();
        }
    }
}

