/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.platform.portal.notifications.veto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ec.notification.NotificationListenerVeto;
import org.nuxeo.runtime.api.Framework;

public class NotificationVeto
implements NotificationListenerVeto {
    private static final Log log = LogFactory.getLog(NotificationVeto.class);
    private List<String> systemUsers;
    public static final String[] authorizedSystemEvents = new String[]{"workflowProcessCanceled", "workflowAbandoned", "workflowTaskAssigned", "workflowTaskCompleted", "workflowTaskRejected"};

    public boolean accept(Event event) throws Exception {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext docCtx;
            NuxeoPrincipal originatingPrincipal;
            String eventName = event.getName();
            return !this.blockSystemEvents(eventName, originatingPrincipal = (NuxeoPrincipal)(docCtx = (DocumentEventContext)event.getContext()).getPrincipal());
        }
        return false;
    }

    protected boolean blockSystemEvents(String eventName, NuxeoPrincipal principal) {
        List<String> systemUsers = this.getSystemUsers();
        boolean block = false;
        if (systemUsers.contains(principal.getName())) {
            block = !Arrays.asList(authorizedSystemEvents).contains(eventName);
        }
        return block;
    }

    private List<String> getSystemUsers() {
        if (this.systemUsers == null) {
            this.systemUsers = new ArrayList<String>();
            this.systemUsers.add("system");
            String defaultAdministratorId = Framework.getProperty((String)"nuxeo.ldap.defaultAdministratorId");
            if (defaultAdministratorId == null) {
                defaultAdministratorId = "Administrator";
            }
            this.systemUsers.add(defaultAdministratorId);
            String vetoForUsers = Framework.getProperty((String)"notification.veto.users");
            if (StringUtils.isNotBlank((String)vetoForUsers)) {
                String[] split = vetoForUsers.split(",");
                for (int i = 0; i < split.length; ++i) {
                    String vetoUser = StringUtils.trim((String)split[i]);
                    if (!StringUtils.isNotBlank((String)vetoUser)) continue;
                    this.systemUsers.add(vetoUser);
                }
            }
        }
        return this.systemUsers;
    }
}

