/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.edition;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.runtime.api.Framework;

public class EditionCacheHelper {
    public static final String USERNAME_KEY = "username";
    public static final String DATE_KEY = "date";
    private static CacheService cacheService;

    private EditionCacheHelper() {
    }

    public static void put(DocumentModel document, List<String> userNames, String cacheName) {
        if (document != null && CollectionUtils.isNotEmpty(userNames)) {
            JSONObject cacheEntry = EditionCacheHelper.buildCacheEntry(userNames);
            try {
                CacheAttributesChecker cache = EditionCacheHelper.getCacheService().getCache(cacheName);
                if (cache != null) {
                    cache.put(document.getId(), (Serializable)cacheEntry);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void put(DocumentModel document, String userName, String cacheName) {
        if (document != null && StringUtils.isNotBlank((String)userName)) {
            JSONObject cacheEntry = EditionCacheHelper.buildCacheEntry(userName);
            try {
                CacheAttributesChecker cache = EditionCacheHelper.getCacheService().getCache(cacheName);
                if (cache != null) {
                    cache.put(document.getId(), (Serializable)cacheEntry);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static JSONObject get(DocumentModel document, String cacheName) {
        JSONObject cacheEntry = null;
        if (document != null) {
            try {
                CacheAttributesChecker cache = EditionCacheHelper.getCacheService().getCache(cacheName);
                if (cache != null) {
                    cacheEntry = (JSONObject)cache.get(document.getId());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return cacheEntry;
    }

    public static void invalidate(DocumentModel document, String cacheName) {
        if (document != null) {
            try {
                CacheAttributesChecker cache = EditionCacheHelper.getCacheService().getCache(cacheName);
                if (cache != null) {
                    cache.invalidate(document.getId());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static JSONObject buildCacheEntry(List<String> userNames) {
        JSONObject cacheEntry = new JSONObject();
        cacheEntry.put((Object)DATE_KEY, (Object)new Date().getTime());
        JSONArray usernamesArray = new JSONArray();
        usernamesArray.addAll(userNames);
        cacheEntry.put((Object)USERNAME_KEY, (Object)usernamesArray);
        return cacheEntry;
    }

    private static JSONObject buildCacheEntry(String userName) {
        JSONObject cacheEntry = new JSONObject();
        cacheEntry.put((Object)DATE_KEY, (Object)new Date().getTime());
        JSONArray usernamesArray = new JSONArray();
        usernamesArray.add((Object)userName);
        cacheEntry.put((Object)USERNAME_KEY, (Object)usernamesArray);
        return cacheEntry;
    }

    private static CacheService getCacheService() {
        if (cacheService == null) {
            cacheService = (CacheService)Framework.getService(CacheService.class);
        }
        return cacheService;
    }
}

