/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.opentoutatice.sharing.operation;

import java.util.Collection;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

@Operation(id="Document.GetSharingPermissions", category="Document", label="Get sharing permissions")
public class GetSharingPermissions {
    public static final String ID = "Document.GetSharingPermissions";
    private static final String MIME_TYPE = "application/json";
    @Context
    private CoreSession session;

    @OperationMethod
    public Object run(DocumentModel document) {
        ACP acp = document.getACP();
        ACL acl = acp.getACL("sharing");
        JSONArray array = new JSONArray();
        if (CollectionUtils.isNotEmpty((Collection)acl)) {
            for (ACE ace : acl) {
                JSONObject object = new JSONObject();
                object.put((Object)"user", (Object)ace.getUsername());
                object.put((Object)"permission", (Object)ace.getPermission());
                array.add((Object)object);
            }
        }
        return new StringBlob(array.toString(), MIME_TYPE);
    }
}

