/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.features.PrincipalHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.security.PrincipalListManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="principalListManager")
@Scope(value=ScopeType.SESSION)
@Install(precedence=56)
public class AcrennesPrincipalListManager
extends PrincipalListManager {
    private static final long serialVersionUID = 1L;
    @Context
    protected PermissionProvider permissionProvider;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    private static final Log log = LogFactory.getLog(AcrennesPrincipalListManager.class);
    protected List<String> preSelectedUsers;

    public List<String> getSelectedUsers() {
        if (this.preSelectedUsers == null) {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            try {
                this.preSelectedUsers = new ArrayList<String>(this.getUserAndGroupCanReadDoc(currentDoc));
            }
            catch (Exception e) {
                log.error((Object)("Error in the search of users and groups entitled to read the document, error: " + e.getMessage()));
            }
            for (String userName : this.preSelectedUsers) {
                super.addToSelectedUsers(userName);
            }
        }
        return super.getSelectedUsers();
    }

    public boolean getSelectedUserListEmpty() {
        return this.getSelectedUsers().isEmpty();
    }

    public void resetSelectedUserList() {
        this.preSelectedUsers.clear();
        super.resetSelectedUserList();
    }

    public void setSelectedUsers(List<String> selectedUsers) {
        this.selectedUsers = selectedUsers;
    }

    private Set<String> getUserAndGroupCanReadDoc(DocumentModel doc) throws Exception {
        String defaultGroup;
        if (null == this.permissionProvider) {
            this.permissionProvider = (PermissionProvider)Framework.getService(PermissionProvider.class);
        }
        PrincipalHelper ph = new PrincipalHelper(this.userManager, this.permissionProvider);
        Set setUsersAndGroups = ph.getUserAndGroupIdsForPermission(doc, "Read", false, false, false);
        ArrayList lstAdmin = new ArrayList();
        ArrayList<String> adminGroups = new ArrayList<String>();
        adminGroups.addAll(this.userManager.getAdministratorsGroups());
        adminGroups.add("Administrators");
        lstAdmin.addAll(adminGroups);
        for (String adminGroup : adminGroups) {
            lstAdmin.addAll(ph.getUserNamesFromGroup(adminGroup, false, false));
        }
        setUsersAndGroups.removeAll(lstAdmin);
        String anonymousUser = this.getAnonymousIfPublicDoc(doc);
        if (StringUtils.isNotBlank((String)anonymousUser)) {
            setUsersAndGroups.remove(anonymousUser);
        }
        if (setUsersAndGroups.contains(defaultGroup = this.userManager.getDefaultGroup())) {
            setUsersAndGroups.remove(defaultGroup);
        }
        return setUsersAndGroups;
    }

    protected String getAnonymousIfPublicDoc(DocumentModel doc) {
        String anonymousUserId = this.userManager.getAnonymousUserId();
        NuxeoPrincipal anonymousPrincipal = this.userManager.getPrincipal(anonymousUserId);
        if (this.documentManager.hasPermission((Principal)anonymousPrincipal, doc.getRef(), "Read")) {
            return anonymousUserId;
        }
        return "";
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"})
    public void resetPreSelecedUsers() {
        if (this.preSelectedUsers != null) {
            for (String userName : this.preSelectedUsers) {
                this.selectedUsers.remove(userName);
            }
            this.preSelectedUsers = null;
        }
    }
}

