/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.automation.features.PrincipalHelper;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="Document.GetFilteredDocumentUsersAndGroups", category="Users & Groups", label="Get Filtered Users and Groups", description="")
public class GetFilteredDocumentUsersAndGroups {
    public static final String ID = "Document.GetFilteredDocumentUsersAndGroups";
    @Context
    protected PermissionProvider permissionProvider;
    @Context
    protected UserManager umgr;
    @Context
    protected OperationContext ctx;
    @Param(name="permission")
    protected String permission;
    @Param(name="variable name")
    protected String key;
    @Param(name="ignore groups", required=false, values={"false"})
    protected boolean ignoreGroups = false;
    @Param(name="resolve groups", required=false, values={"false"})
    protected boolean resolveGroups = false;
    @Param(name="prefix identifiers", required=false, values={"false"})
    protected boolean prefixIds = false;
    @Param(name="ignore groups with permissions", required=false)
    protected String permissionsToIgnore = "";
    @Param(name="explicit users and groups to ignore", required=false)
    protected String usersAndGroupsToIgnore = "";

    @OperationMethod
    public DocumentModel run(DocumentModel input) throws Exception {
        PrincipalHelper ph = new PrincipalHelper(this.umgr, this.permissionProvider);
        Set result = ph.getUserAndGroupIdsForPermission(input, this.permission, this.ignoreGroups, this.resolveGroups, this.prefixIds);
        if (StringUtils.isNotBlank((String)this.permissionsToIgnore)) {
            String[] permissionsToIgnoreList;
            for (String permissionToIgnore : permissionsToIgnoreList = this.permissionsToIgnore.split(",")) {
                Set rslt = ph.getUserAndGroupIdsForPermission(input, permissionToIgnore.trim(), this.ignoreGroups, this.resolveGroups, this.prefixIds);
                for (String principalToIgnore : rslt) {
                    result.remove(principalToIgnore);
                }
            }
        }
        if (StringUtils.isNotBlank((String)this.usersAndGroupsToIgnore)) {
            String[] usersAndGroupsToIgnoreList;
            for (String userOrGroup : usersAndGroupsToIgnoreList = this.usersAndGroupsToIgnore.split(",")) {
                result.remove(userOrGroup.trim());
            }
        }
        this.ctx.put(this.key, (Object)new StringList((Collection)result));
        return input;
    }
}

