/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.DynamicMetaDataImpl;
import com.sun.jdmk.Introspector;
import com.sun.jdmk.MBeanInstantiator;
import com.sun.jdmk.internal.ClassLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class MetaDataImpl
extends DynamicMetaDataImpl {
    private static final String dbgTag = "MetaDataImpl";
    private static Hashtable mbeanInfoCache = new Hashtable();
    private static Hashtable mbeanInterfaceCache = new Hashtable();
    private static final Hashtable primitiveClasses = new Hashtable(8);
    private final ClassLogger logger;

    MetaDataImpl(MBeanInstantiator instantiator) {
        super(instantiator);
        primitiveClasses.put(Boolean.TYPE.toString(), Boolean.TYPE);
        primitiveClasses.put(Character.TYPE.toString(), Character.TYPE);
        primitiveClasses.put(Byte.TYPE.toString(), Byte.TYPE);
        primitiveClasses.put(Short.TYPE.toString(), Short.TYPE);
        primitiveClasses.put(Integer.TYPE.toString(), Integer.TYPE);
        primitiveClasses.put(Long.TYPE.toString(), Long.TYPE);
        primitiveClasses.put(Float.TYPE.toString(), Float.TYPE);
        primitiveClasses.put(Double.TYPE.toString(), Double.TYPE);
        this.logger = new ClassLogger("com.sun.jdmk.mbeanserver", dbgTag);
    }

    @Override
    public synchronized void testCompliance(Class c) throws NotCompliantMBeanException {
        Class inter;
        MBeanInfo bi = Introspector.testCompliance(c);
        if (bi != null && mbeanInfoCache.get(c) == null) {
            mbeanInfoCache.put(c, bi);
        }
        if ((inter = Introspector.getMBeanInterface(c)) != null && mbeanInterfaceCache.get(c) == null) {
            mbeanInterfaceCache.put(c, inter);
        }
    }

    public Class getMBeanInterfaceFromClass(Class c) {
        Class inter = (Class)mbeanInterfaceCache.get(c);
        return inter;
    }

    public MBeanInfo getMBeanInfoFromClass(Class beanClass) throws IntrospectionException, NotCompliantMBeanException {
        MBeanInfo bi = (MBeanInfo)mbeanInfoCache.get(beanClass);
        if (bi != null) {
            return (MBeanInfo)bi.clone();
        }
        this.testCompliance(beanClass);
        bi = (MBeanInfo)mbeanInfoCache.get(beanClass);
        if (bi != null) {
            return (MBeanInfo)bi.clone();
        }
        return bi;
    }

    public static Method findMethod(Class classObj, String name, Class[] parameterTypes) {
        Method method = null;
        try {
            method = classObj.getMethod(name, parameterTypes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findMethod(Class classObj, String name) {
        Method method = null;
        try {
            Method[] methods = classObj.getMethods();
            int i = 0;
            while (i < methods.length && !methods[i].getName().equals(name)) {
                ++i;
            }
            if (i < methods.length) {
                method = methods[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findMethod(Class classObj, String name, int paramCount) {
        Method method = null;
        try {
            Method[] methods = classObj.getMethods();
            int i = 0;
            boolean found = false;
            while (i < methods.length && !found) {
                found = methods[i].getName().equals(name);
                if (found) {
                    found = methods[i].getParameterTypes().length == paramCount;
                }
                ++i;
            }
            if (found) {
                method = methods[i - 1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    public static Method findGetter(Class classObj, String attribute) {
        Method m = MetaDataImpl.findMethod(classObj, "get" + attribute, null);
        if (m == null) {
            m = MetaDataImpl.findMethod(classObj, "is" + attribute, null);
        }
        return m;
    }

    public static Method findSetter(Class classObj, String attribute, Class type) {
        Class<?>[] pars;
        Method mth = MetaDataImpl.findMethod(classObj, "set" + attribute, 1);
        if (mth != null && (pars = mth.getParameterTypes())[0].isAssignableFrom(type)) {
            return mth;
        }
        return null;
    }

    public static Method findSetter(Class classObj, String attribute) {
        return MetaDataImpl.findMethod(classObj, "set" + attribute, 1);
    }

    public static Constructor findConstructor(Class theClass, Class[] parameterTypes) {
        Constructor mth = null;
        try {
            mth = theClass.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
        return mth;
    }

    public static Class findClassForPrim(String primName) {
        return (Class)primitiveClasses.get(primName);
    }

    public static Class findPrimForClass(Object value) {
        if (value instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (value instanceof Character) {
            return Character.TYPE;
        }
        if (value instanceof Byte) {
            return Byte.TYPE;
        }
        if (value instanceof Short) {
            return Short.TYPE;
        }
        if (value instanceof Integer) {
            return Integer.TYPE;
        }
        if (value instanceof Long) {
            return Long.TYPE;
        }
        if (value instanceof Float) {
            return Float.TYPE;
        }
        if (value instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    @Override
    public String getMBeanClassName(Object moi) throws IntrospectionException, NotCompliantMBeanException {
        if (moi instanceof DynamicMBean) {
            return super.getMBeanClassName(moi);
        }
        return moi.getClass().getName();
    }

    @Override
    public MBeanInfo getMBeanInfo(Object moi) throws IntrospectionException {
        if (moi instanceof DynamicMBean) {
            return super.getMBeanInfo(moi);
        }
        try {
            MBeanInfo mbi = this.getMBeanInfoFromClass(moi.getClass());
            return new MBeanInfo(mbi.getClassName(), mbi.getDescription(), mbi.getAttributes(), mbi.getConstructors(), mbi.getOperations(), this.findNotifications(moi));
        }
        catch (NotCompliantMBeanException x) {
            this.logger.finest("getMBeanInfo", x);
            throw new IntrospectionException("Can't build MBeanInfo for " + moi.getClass().getName());
        }
    }

    @Override
    public Object getAttribute(Object instance, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (instance instanceof DynamicMBean) {
            return super.getAttribute(instance, attribute);
        }
        Class mbeanClass = this.getMBeanInterfaceFromClass(instance.getClass());
        if (this.logger.finestOn()) {
            this.logger.finest("getAttribute", "MBean Class is " + instance.getClass());
            this.logger.finest("getAttribute", "MBean Interface is " + mbeanClass);
        }
        return this.getAttribute(instance, attribute, mbeanClass);
    }

    @Override
    public AttributeList getAttributes(Object instance, String[] attributes) throws ReflectionException {
        if (instance instanceof DynamicMBean) {
            return super.getAttributes(instance, attributes);
        }
        Class mbeanClass = this.getMBeanInterfaceFromClass(instance.getClass());
        if (this.logger.finestOn()) {
            this.logger.finest("getAttributes", "MBean Class is " + instance.getClass());
            this.logger.finest("getAttributes", "MBean Interface is " + mbeanClass);
        }
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occurred trying to invoke the getter on the MBean");
        }
        int maxLimit = attributes.length;
        AttributeList result = new AttributeList(maxLimit);
        int i = 0;
        while (i < maxLimit) {
            block6: {
                String elmt = attributes[i];
                try {
                    Object value = this.getAttribute(instance, elmt, mbeanClass);
                    result.add(new Attribute(elmt, value));
                }
                catch (Exception excep) {
                    if (!this.logger.finestOn()) break block6;
                    this.logger.finest("getAttributes", "Object= " + instance + ", Attribute=" + elmt + " failed: " + excep);
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public AttributeList setAttributes(Object instance, AttributeList attributes) throws ReflectionException {
        if (instance instanceof DynamicMBean) {
            return super.setAttributes(instance, attributes);
        }
        Class<?> objClass = instance.getClass();
        Class mbeanClass = this.getMBeanInterfaceFromClass(objClass);
        ClassLoader aLoader = objClass.getClassLoader();
        if (this.logger.finestOn()) {
            this.logger.finest("setAttributes", "MBean Class is " + instance.getClass());
            this.logger.finest("setAttributes", "MBean Interface is " + mbeanClass);
        }
        if (attributes == null) {
            return new AttributeList();
        }
        AttributeList result = new AttributeList(attributes.size());
        for (Attribute attr : attributes) {
            String id = attr.getName();
            Object value = attr.getValue();
            try {
                Object newValue = this.setAttribute(instance, attr, mbeanClass);
                if (this.logger.traceOn()) {
                    this.logger.trace("setAttributes", "Updating the list\n");
                }
                result.add(new Attribute(id, newValue));
            }
            catch (Exception excep) {
                if (!this.logger.finestOn()) continue;
                this.logger.finest("setAttributes", "Unexpected exception occurred: " + excep.getClass().getName());
            }
        }
        return result;
    }

    @Override
    public Object setAttribute(Object instance, Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (instance instanceof DynamicMBean) {
            return super.setAttribute(instance, attribute);
        }
        Class mbeanClass = this.getMBeanInterfaceFromClass(instance.getClass());
        if (this.logger.finestOn()) {
            this.logger.finest("setAttribute", "MBean Class is " + instance.getClass());
            this.logger.finest("setAttribute", "MBean Interface is " + mbeanClass);
        }
        return this.setAttribute(instance, attribute, mbeanClass);
    }

    @Override
    public Object invoke(Object instance, String operationName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Class[] tab;
        Method mth;
        if (operationName == null) {
            IllegalArgumentException r = new IllegalArgumentException("Operation name  cannot be null");
            throw new RuntimeOperationsException(r, "Exception occurred trying to invoke the operation on the MBean");
        }
        if (instance instanceof DynamicMBean) {
            return super.invoke(instance, operationName, params, signature);
        }
        Class<?> objClass = instance.getClass();
        Class mbeanClass = this.getMBeanInterfaceFromClass(objClass);
        ClassLoader aLoader = objClass.getClassLoader();
        if (this.logger.finestOn()) {
            this.logger.finest("invoke", "MBean Class is " + instance.getClass());
            this.logger.finest("invoke", "MBean Interface is " + mbeanClass);
        }
        if ((mth = MetaDataImpl.findMethod(mbeanClass, operationName, tab = signature == null ? null : this.instantiator.findSignatureClasses(signature, aLoader))) == null) {
            if (this.logger.traceOn()) {
                this.logger.trace("invoke", String.valueOf(operationName) + " not found in class " + mbeanClass.getName());
            }
            throw new ReflectionException(new NoSuchMethodException(operationName), "The operation with name " + operationName + " could not be found");
        }
        if (this.logger.traceOn()) {
            this.logger.trace("invoke", "Invoking " + operationName);
        }
        Object result = null;
        try {
            Object[] args = this.instantiator.checkTransferParameters(aLoader, params);
            result = mth.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            this.logger.finest("invoke", e);
            throw new ReflectionException(e, "IllegalAccessException occurred trying to invoke operation " + operationName);
        }
        catch (RuntimeException e) {
            this.logger.finest("invoke", e);
            throw new RuntimeOperationsException(e, "RuntimeException occurred trying to invoke operation " + operationName);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            this.logger.finest("invoke", t);
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException thrown in operation " + operationName);
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error thrown in operation " + operationName);
            }
            throw new MBeanException((Exception)t, "Exception thrown in operation " + operationName);
        }
        if (this.logger.traceOn()) {
            this.logger.trace("invoke", "Send the result");
        }
        return result;
    }

    @Override
    public boolean isInstanceOf(Object instance, String className) throws ReflectionException {
        boolean result;
        if (instance instanceof DynamicMBean && (result = super.isInstanceOf(instance, className))) {
            return true;
        }
        Class c = this.instantiator.findClass(className, instance.getClass().getClassLoader());
        return c.isInstance(instance);
    }

    protected Object getAttribute(Object instance, String attribute, Class mbeanClass) throws MBeanException, AttributeNotFoundException, ReflectionException {
        if (attribute == null) {
            IllegalArgumentException r = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(r, "Exception occurred trying to invoke the getter on the MBean");
        }
        Method meth = null;
        meth = MetaDataImpl.findGetter(mbeanClass, attribute);
        if (meth == null) {
            if (this.logger.traceOn()) {
                this.logger.trace("getAttribute", "Cannot find getter for " + attribute + " in class " + mbeanClass.getName());
            }
            throw new AttributeNotFoundException(String.valueOf(attribute) + " not accessible");
        }
        if (this.logger.traceOn()) {
            this.logger.trace("getAttribute", "Invoke callback");
        }
        Object result = null;
        try {
            result = meth.invoke(instance, null);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                this.logger.finest("getAttribute", t);
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException thrown in the getter for the attribute " + attribute);
            }
            if (t instanceof Error) {
                this.logger.finest("getAttribute", t);
                throw new RuntimeErrorException((Error)t, "Error thrown in the getter for the attribute " + attribute);
            }
            this.logger.finest("getAttribute", t);
            throw new MBeanException((Exception)t, "Exception thrown in the getter for the attribute " + attribute);
        }
        catch (RuntimeException e) {
            this.logger.finest("getAttribute", e);
            throw new RuntimeOperationsException(e, "RuntimeException thrown trying to invoke the getter for the attribute " + attribute);
        }
        catch (IllegalAccessException e) {
            this.logger.finest("getAttribute", e);
            throw new ReflectionException(e, "Exception thrown trying to invoke the getter for the attribute " + attribute);
        }
        catch (Error e) {
            this.logger.finest("getAttribute", e);
            throw new RuntimeErrorException(e, "Error thrown trying to invoke the getter  for the attribute " + attribute);
        }
        if (this.logger.traceOn()) {
            this.logger.trace("getAttribute", String.valueOf(attribute) + "= " + result + "\n");
        }
        return result;
    }

    protected Object setAttribute(Object instance, Attribute attribute, Class mbeanClass) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Class primClass;
        if (attribute == null) {
            IllegalArgumentException r = new IllegalArgumentException("Attribute name cannot be null");
            throw new RuntimeOperationsException(r, "Exception occurred trying to invoke the setter on the MBean");
        }
        Class<?> objClass = instance.getClass();
        ClassLoader aLoader = objClass.getClassLoader();
        Object result = null;
        Attribute attr = this.instantiator.checkTransferAttribute(aLoader, attribute);
        Object value = attr.getValue();
        String attname = attr.getName();
        Method meth = null;
        meth = value == null ? MetaDataImpl.findSetter(mbeanClass, attname) : MetaDataImpl.findSetter(mbeanClass, attname, value.getClass());
        if (meth == null && (primClass = MetaDataImpl.findPrimForClass(value)) != null) {
            meth = MetaDataImpl.findSetter(mbeanClass, attname, primClass);
        }
        if (meth == null) {
            meth = MetaDataImpl.findSetter(mbeanClass, attname);
            if (meth == null) {
                if (this.logger.traceOn()) {
                    this.logger.trace("setAttribute", "Cannot find setter for " + attribute + " in class " + mbeanClass.getName());
                }
                throw new AttributeNotFoundException(String.valueOf(attname) + " not accessible");
            }
            Object v = attribute.getValue();
            if (v == null) {
                throw new InvalidAttributeValueException("attribute= " + attname + " value = null");
            }
            throw new InvalidAttributeValueException("attribute= " + attname + " value = " + v);
        }
        if (this.logger.traceOn()) {
            this.logger.trace("setAttribute", "Invoking the set method for " + attname);
        }
        Object[] values = new Object[]{value};
        try {
            result = meth.invoke(instance, values);
        }
        catch (IllegalAccessException e) {
            this.logger.finest("setAttribute", e);
            throw new ReflectionException(e, "IllegalAccessException occurred trying to invoke the setter on the MBean");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            this.logger.finest("setAttribute", t);
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException thrown in the MBean's setter");
            }
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t, "Error thrown in the MBean's setter");
            }
            throw new MBeanException((Exception)t, "Exception thrown in the MBean's setter");
        }
        if (this.logger.traceOn()) {
            this.logger.trace("setAttribute", String.valueOf(attname) + "= " + value);
        }
        return value;
    }

    static String[] findSignatures(Class[] clz) {
        String[] signers = new String[clz.length];
        int i = 0;
        while (i < clz.length) {
            signers[i] = MetaDataImpl.findSignature(clz[i]);
            ++i;
        }
        return signers;
    }

    static String findSignature(Class clz) {
        return clz.getName();
    }

    private MBeanNotificationInfo[] findNotifications(Object moi) {
        if (moi instanceof NotificationBroadcaster) {
            MBeanNotificationInfo[] mbn = ((NotificationBroadcaster)moi).getNotificationInfo();
            if (mbn == null) {
                return new MBeanNotificationInfo[0];
            }
            MBeanNotificationInfo[] result = new MBeanNotificationInfo[mbn.length];
            int i = 0;
            while (i < mbn.length) {
                result[i] = (MBeanNotificationInfo)mbn[i].clone();
                ++i;
            }
            return result;
        }
        return new MBeanNotificationInfo[0];
    }
}

