/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

class HttpSocket
extends GenericHttpSocket {
    private int backlog = 10;
    private Socket sckAccept = null;
    private Socket clientSocket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private ServerSocket serverSocket = null;

    public HttpSocket() {
    }

    public HttpSocket(int port) {
        this.port = port;
    }

    public HttpSocket(int port, InetAddress bindAddr) {
        this.port = port;
        this.bindAddr = bindAddr;
    }

    @Override
    public GenericHttpSocket createServerSocket(int port) {
        HttpSocket newSocket = new HttpSocket(port);
        newSocket.setTimeout(this.getTimeout());
        return newSocket;
    }

    @Override
    public GenericHttpSocket createServerSocket(int port, InetAddress bindAddr) {
        HttpSocket newSocket = new HttpSocket(port, bindAddr);
        newSocket.setTimeout(this.getTimeout());
        return newSocket;
    }

    @Override
    public GenericHttpSocket createClientSocket() {
        HttpSocket newSocket = new HttpSocket(0);
        newSocket.setTimeout(this.getTimeout());
        return newSocket;
    }

    @Override
    public String getProtocol() {
        return "http";
    }

    @Override
    public void doBind() throws IOException {
        this.serverSocket = this.bindAddr == null ? new ServerSocket(this.port, this.backlog) : new ServerSocket(this.port, this.backlog, this.bindAddr);
    }

    @Override
    public void doUnbind() throws IOException {
        this.serverSocket.close();
    }

    @Override
    public void doConnect(String serverName, int serverPort) throws UnknownHostException, IOException, CommunicationException {
        this.clientSocket = new Socket(serverName, serverPort);
        this.clientSocket.setSoTimeout(this.getTimeout());
    }

    @Override
    public void doDisconnect() throws IOException, CommunicationException {
        if (this.serverSocket != null) {
            this.sckAccept.close();
            this.sckAccept = null;
        } else if (this.clientSocket != null) {
            this.clientSocket.close();
            this.clientSocket = null;
        }
    }

    @Override
    public void doSend(String header, byte[] content) throws IOException {
        this.outputStream = this.serverSocket != null ? this.sckAccept.getOutputStream() : this.clientSocket.getOutputStream();
        this.outputStream.write(header.getBytes());
        if (content != null) {
            this.outputStream.write(content);
        }
        this.outputStream.flush();
    }

    @Override
    public InputStream doReceive() throws IOException {
        if (this.serverSocket != null) {
            this.sckAccept = this.serverSocket.accept();
            this.sckAccept.setSoTimeout(this.getTimeout());
            this.inputStream = this.sckAccept.getInputStream();
        } else {
            this.inputStream = this.clientSocket.getInputStream();
        }
        return this.inputStream;
    }

    @Override
    public InputStream doGetInputStream() throws IOException {
        this.inputStream = this.serverSocket != null ? this.sckAccept.getInputStream() : this.clientSocket.getInputStream();
        return this.inputStream;
    }

    @Override
    public OutputStream doGetOutputStream() throws IOException {
        this.outputStream = this.serverSocket != null ? this.sckAccept.getOutputStream() : this.clientSocket.getOutputStream();
        return this.outputStream;
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.serverSocket != null) {
            return this.serverSocket.getInetAddress();
        }
        return this.clientSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.clientSocket.getLocalPort();
    }

    @Override
    public InetAddress getRemoteAddress() {
        if (this.serverSocket != null) {
            return this.sckAccept.getInetAddress();
        }
        return this.clientSocket.getInetAddress();
    }

    @Override
    public int getRemotePort() {
        if (this.serverSocket != null) {
            return this.sckAccept.getPort();
        }
        return this.clientSocket.getPort();
    }

    public String toString() {
        return this.serverSocket.toString();
    }
}

